//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/devcenter/armdevcenter"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// DevBoxDefinitionsServer is a fake server for instances of the armdevcenter.DevBoxDefinitionsClient type.
type DevBoxDefinitionsServer struct {
	// BeginCreateOrUpdate is the fake for method DevBoxDefinitionsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, devCenterName string, devBoxDefinitionName string, body armdevcenter.DevBoxDefinition, options *armdevcenter.DevBoxDefinitionsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armdevcenter.DevBoxDefinitionsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method DevBoxDefinitionsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, devCenterName string, devBoxDefinitionName string, options *armdevcenter.DevBoxDefinitionsClientBeginDeleteOptions) (resp azfake.PollerResponder[armdevcenter.DevBoxDefinitionsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DevBoxDefinitionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, devCenterName string, devBoxDefinitionName string, options *armdevcenter.DevBoxDefinitionsClientGetOptions) (resp azfake.Responder[armdevcenter.DevBoxDefinitionsClientGetResponse], errResp azfake.ErrorResponder)

	// GetByProject is the fake for method DevBoxDefinitionsClient.GetByProject
	// HTTP status codes to indicate success: http.StatusOK
	GetByProject func(ctx context.Context, resourceGroupName string, projectName string, devBoxDefinitionName string, options *armdevcenter.DevBoxDefinitionsClientGetByProjectOptions) (resp azfake.Responder[armdevcenter.DevBoxDefinitionsClientGetByProjectResponse], errResp azfake.ErrorResponder)

	// NewListByDevCenterPager is the fake for method DevBoxDefinitionsClient.NewListByDevCenterPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDevCenterPager func(resourceGroupName string, devCenterName string, options *armdevcenter.DevBoxDefinitionsClientListByDevCenterOptions) (resp azfake.PagerResponder[armdevcenter.DevBoxDefinitionsClientListByDevCenterResponse])

	// NewListByProjectPager is the fake for method DevBoxDefinitionsClient.NewListByProjectPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByProjectPager func(resourceGroupName string, projectName string, options *armdevcenter.DevBoxDefinitionsClientListByProjectOptions) (resp azfake.PagerResponder[armdevcenter.DevBoxDefinitionsClientListByProjectResponse])

	// BeginUpdate is the fake for method DevBoxDefinitionsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, devCenterName string, devBoxDefinitionName string, body armdevcenter.DevBoxDefinitionUpdate, options *armdevcenter.DevBoxDefinitionsClientBeginUpdateOptions) (resp azfake.PollerResponder[armdevcenter.DevBoxDefinitionsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewDevBoxDefinitionsServerTransport creates a new instance of DevBoxDefinitionsServerTransport with the provided implementation.
// The returned DevBoxDefinitionsServerTransport instance is connected to an instance of armdevcenter.DevBoxDefinitionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDevBoxDefinitionsServerTransport(srv *DevBoxDefinitionsServer) *DevBoxDefinitionsServerTransport {
	return &DevBoxDefinitionsServerTransport{
		srv:                     srv,
		beginCreateOrUpdate:     newTracker[azfake.PollerResponder[armdevcenter.DevBoxDefinitionsClientCreateOrUpdateResponse]](),
		beginDelete:             newTracker[azfake.PollerResponder[armdevcenter.DevBoxDefinitionsClientDeleteResponse]](),
		newListByDevCenterPager: newTracker[azfake.PagerResponder[armdevcenter.DevBoxDefinitionsClientListByDevCenterResponse]](),
		newListByProjectPager:   newTracker[azfake.PagerResponder[armdevcenter.DevBoxDefinitionsClientListByProjectResponse]](),
		beginUpdate:             newTracker[azfake.PollerResponder[armdevcenter.DevBoxDefinitionsClientUpdateResponse]](),
	}
}

// DevBoxDefinitionsServerTransport connects instances of armdevcenter.DevBoxDefinitionsClient to instances of DevBoxDefinitionsServer.
// Don't use this type directly, use NewDevBoxDefinitionsServerTransport instead.
type DevBoxDefinitionsServerTransport struct {
	srv                     *DevBoxDefinitionsServer
	beginCreateOrUpdate     *tracker[azfake.PollerResponder[armdevcenter.DevBoxDefinitionsClientCreateOrUpdateResponse]]
	beginDelete             *tracker[azfake.PollerResponder[armdevcenter.DevBoxDefinitionsClientDeleteResponse]]
	newListByDevCenterPager *tracker[azfake.PagerResponder[armdevcenter.DevBoxDefinitionsClientListByDevCenterResponse]]
	newListByProjectPager   *tracker[azfake.PagerResponder[armdevcenter.DevBoxDefinitionsClientListByProjectResponse]]
	beginUpdate             *tracker[azfake.PollerResponder[armdevcenter.DevBoxDefinitionsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for DevBoxDefinitionsServerTransport.
func (d *DevBoxDefinitionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DevBoxDefinitionsClient.BeginCreateOrUpdate":
		resp, err = d.dispatchBeginCreateOrUpdate(req)
	case "DevBoxDefinitionsClient.BeginDelete":
		resp, err = d.dispatchBeginDelete(req)
	case "DevBoxDefinitionsClient.Get":
		resp, err = d.dispatchGet(req)
	case "DevBoxDefinitionsClient.GetByProject":
		resp, err = d.dispatchGetByProject(req)
	case "DevBoxDefinitionsClient.NewListByDevCenterPager":
		resp, err = d.dispatchNewListByDevCenterPager(req)
	case "DevBoxDefinitionsClient.NewListByProjectPager":
		resp, err = d.dispatchNewListByProjectPager(req)
	case "DevBoxDefinitionsClient.BeginUpdate":
		resp, err = d.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DevBoxDefinitionsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := d.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/devcenters/(?P<devCenterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devboxdefinitions/(?P<devBoxDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdevcenter.DevBoxDefinition](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		devCenterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("devCenterName")])
		if err != nil {
			return nil, err
		}
		devBoxDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("devBoxDefinitionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, devCenterNameParam, devBoxDefinitionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		d.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		d.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		d.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (d *DevBoxDefinitionsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := d.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/devcenters/(?P<devCenterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devboxdefinitions/(?P<devBoxDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		devCenterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("devCenterName")])
		if err != nil {
			return nil, err
		}
		devBoxDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("devBoxDefinitionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDelete(req.Context(), resourceGroupNameParam, devCenterNameParam, devBoxDefinitionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		d.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		d.beginDelete.remove(req)
	}

	return resp, nil
}

func (d *DevBoxDefinitionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/devcenters/(?P<devCenterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devboxdefinitions/(?P<devBoxDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	devCenterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("devCenterName")])
	if err != nil {
		return nil, err
	}
	devBoxDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("devBoxDefinitionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, devCenterNameParam, devBoxDefinitionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DevBoxDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DevBoxDefinitionsServerTransport) dispatchGetByProject(req *http.Request) (*http.Response, error) {
	if d.srv.GetByProject == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByProject not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/projects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devboxdefinitions/(?P<devBoxDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
	if err != nil {
		return nil, err
	}
	devBoxDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("devBoxDefinitionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetByProject(req.Context(), resourceGroupNameParam, projectNameParam, devBoxDefinitionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DevBoxDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DevBoxDefinitionsServerTransport) dispatchNewListByDevCenterPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByDevCenterPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDevCenterPager not implemented")}
	}
	newListByDevCenterPager := d.newListByDevCenterPager.get(req)
	if newListByDevCenterPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/devcenters/(?P<devCenterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devboxdefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		devCenterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("devCenterName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armdevcenter.DevBoxDefinitionsClientListByDevCenterOptions
		if topParam != nil {
			options = &armdevcenter.DevBoxDefinitionsClientListByDevCenterOptions{
				Top: topParam,
			}
		}
		resp := d.srv.NewListByDevCenterPager(resourceGroupNameParam, devCenterNameParam, options)
		newListByDevCenterPager = &resp
		d.newListByDevCenterPager.add(req, newListByDevCenterPager)
		server.PagerResponderInjectNextLinks(newListByDevCenterPager, req, func(page *armdevcenter.DevBoxDefinitionsClientListByDevCenterResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDevCenterPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByDevCenterPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDevCenterPager) {
		d.newListByDevCenterPager.remove(req)
	}
	return resp, nil
}

func (d *DevBoxDefinitionsServerTransport) dispatchNewListByProjectPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByProjectPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByProjectPager not implemented")}
	}
	newListByProjectPager := d.newListByProjectPager.get(req)
	if newListByProjectPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/projects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devboxdefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armdevcenter.DevBoxDefinitionsClientListByProjectOptions
		if topParam != nil {
			options = &armdevcenter.DevBoxDefinitionsClientListByProjectOptions{
				Top: topParam,
			}
		}
		resp := d.srv.NewListByProjectPager(resourceGroupNameParam, projectNameParam, options)
		newListByProjectPager = &resp
		d.newListByProjectPager.add(req, newListByProjectPager)
		server.PagerResponderInjectNextLinks(newListByProjectPager, req, func(page *armdevcenter.DevBoxDefinitionsClientListByProjectResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByProjectPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByProjectPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByProjectPager) {
		d.newListByProjectPager.remove(req)
	}
	return resp, nil
}

func (d *DevBoxDefinitionsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := d.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/devcenters/(?P<devCenterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devboxdefinitions/(?P<devBoxDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdevcenter.DevBoxDefinitionUpdate](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		devCenterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("devCenterName")])
		if err != nil {
			return nil, err
		}
		devBoxDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("devBoxDefinitionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginUpdate(req.Context(), resourceGroupNameParam, devCenterNameParam, devBoxDefinitionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		d.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		d.beginUpdate.remove(req)
	}

	return resp, nil
}
