//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armkusto

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/kusto/armkusto"
	moduleVersion = "v2.2.0"
)

// AzureSKUName - SKU name.
type AzureSKUName string

const (
	AzureSKUNameDevNoSLAStandardD11V2 AzureSKUName = "Dev(No SLA)_Standard_D11_v2"
	AzureSKUNameDevNoSLAStandardE2AV4 AzureSKUName = "Dev(No SLA)_Standard_E2a_v4"
	AzureSKUNameStandardD11V2         AzureSKUName = "Standard_D11_v2"
	AzureSKUNameStandardD12V2         AzureSKUName = "Standard_D12_v2"
	AzureSKUNameStandardD13V2         AzureSKUName = "Standard_D13_v2"
	AzureSKUNameStandardD14V2         AzureSKUName = "Standard_D14_v2"
	AzureSKUNameStandardD16DV5        AzureSKUName = "Standard_D16d_v5"
	AzureSKUNameStandardD32DV4        AzureSKUName = "Standard_D32d_v4"
	AzureSKUNameStandardD32DV5        AzureSKUName = "Standard_D32d_v5"
	AzureSKUNameStandardDS13V21TBPS   AzureSKUName = "Standard_DS13_v2+1TB_PS"
	AzureSKUNameStandardDS13V22TBPS   AzureSKUName = "Standard_DS13_v2+2TB_PS"
	AzureSKUNameStandardDS14V23TBPS   AzureSKUName = "Standard_DS14_v2+3TB_PS"
	AzureSKUNameStandardDS14V24TBPS   AzureSKUName = "Standard_DS14_v2+4TB_PS"
	AzureSKUNameStandardE16AV4        AzureSKUName = "Standard_E16a_v4"
	AzureSKUNameStandardE16AdsV5      AzureSKUName = "Standard_E16ads_v5"
	AzureSKUNameStandardE16AsV43TBPS  AzureSKUName = "Standard_E16as_v4+3TB_PS"
	AzureSKUNameStandardE16AsV44TBPS  AzureSKUName = "Standard_E16as_v4+4TB_PS"
	AzureSKUNameStandardE16AsV53TBPS  AzureSKUName = "Standard_E16as_v5+3TB_PS"
	AzureSKUNameStandardE16AsV54TBPS  AzureSKUName = "Standard_E16as_v5+4TB_PS"
	AzureSKUNameStandardE16DV4        AzureSKUName = "Standard_E16d_v4"
	AzureSKUNameStandardE16DV5        AzureSKUName = "Standard_E16d_v5"
	AzureSKUNameStandardE16SV43TBPS   AzureSKUName = "Standard_E16s_v4+3TB_PS"
	AzureSKUNameStandardE16SV44TBPS   AzureSKUName = "Standard_E16s_v4+4TB_PS"
	AzureSKUNameStandardE16SV53TBPS   AzureSKUName = "Standard_E16s_v5+3TB_PS"
	AzureSKUNameStandardE16SV54TBPS   AzureSKUName = "Standard_E16s_v5+4TB_PS"
	AzureSKUNameStandardE2AV4         AzureSKUName = "Standard_E2a_v4"
	AzureSKUNameStandardE2AdsV5       AzureSKUName = "Standard_E2ads_v5"
	AzureSKUNameStandardE2DV4         AzureSKUName = "Standard_E2d_v4"
	AzureSKUNameStandardE2DV5         AzureSKUName = "Standard_E2d_v5"
	AzureSKUNameStandardE4AV4         AzureSKUName = "Standard_E4a_v4"
	AzureSKUNameStandardE4AdsV5       AzureSKUName = "Standard_E4ads_v5"
	AzureSKUNameStandardE4DV4         AzureSKUName = "Standard_E4d_v4"
	AzureSKUNameStandardE4DV5         AzureSKUName = "Standard_E4d_v5"
	AzureSKUNameStandardE64IV3        AzureSKUName = "Standard_E64i_v3"
	AzureSKUNameStandardE80IDsV4      AzureSKUName = "Standard_E80ids_v4"
	AzureSKUNameStandardE8AV4         AzureSKUName = "Standard_E8a_v4"
	AzureSKUNameStandardE8AdsV5       AzureSKUName = "Standard_E8ads_v5"
	AzureSKUNameStandardE8AsV41TBPS   AzureSKUName = "Standard_E8as_v4+1TB_PS"
	AzureSKUNameStandardE8AsV42TBPS   AzureSKUName = "Standard_E8as_v4+2TB_PS"
	AzureSKUNameStandardE8AsV51TBPS   AzureSKUName = "Standard_E8as_v5+1TB_PS"
	AzureSKUNameStandardE8AsV52TBPS   AzureSKUName = "Standard_E8as_v5+2TB_PS"
	AzureSKUNameStandardE8DV4         AzureSKUName = "Standard_E8d_v4"
	AzureSKUNameStandardE8DV5         AzureSKUName = "Standard_E8d_v5"
	AzureSKUNameStandardE8SV41TBPS    AzureSKUName = "Standard_E8s_v4+1TB_PS"
	AzureSKUNameStandardE8SV42TBPS    AzureSKUName = "Standard_E8s_v4+2TB_PS"
	AzureSKUNameStandardE8SV51TBPS    AzureSKUName = "Standard_E8s_v5+1TB_PS"
	AzureSKUNameStandardE8SV52TBPS    AzureSKUName = "Standard_E8s_v5+2TB_PS"
	AzureSKUNameStandardEC16AdsV5     AzureSKUName = "Standard_EC16ads_v5"
	AzureSKUNameStandardEC16AsV53TBPS AzureSKUName = "Standard_EC16as_v5+3TB_PS"
	AzureSKUNameStandardEC16AsV54TBPS AzureSKUName = "Standard_EC16as_v5+4TB_PS"
	AzureSKUNameStandardEC8AdsV5      AzureSKUName = "Standard_EC8ads_v5"
	AzureSKUNameStandardEC8AsV51TBPS  AzureSKUName = "Standard_EC8as_v5+1TB_PS"
	AzureSKUNameStandardEC8AsV52TBPS  AzureSKUName = "Standard_EC8as_v5+2TB_PS"
	AzureSKUNameStandardL16AsV3       AzureSKUName = "Standard_L16as_v3"
	AzureSKUNameStandardL16S          AzureSKUName = "Standard_L16s"
	AzureSKUNameStandardL16SV2        AzureSKUName = "Standard_L16s_v2"
	AzureSKUNameStandardL16SV3        AzureSKUName = "Standard_L16s_v3"
	AzureSKUNameStandardL32AsV3       AzureSKUName = "Standard_L32as_v3"
	AzureSKUNameStandardL32SV3        AzureSKUName = "Standard_L32s_v3"
	AzureSKUNameStandardL4S           AzureSKUName = "Standard_L4s"
	AzureSKUNameStandardL8AsV3        AzureSKUName = "Standard_L8as_v3"
	AzureSKUNameStandardL8S           AzureSKUName = "Standard_L8s"
	AzureSKUNameStandardL8SV2         AzureSKUName = "Standard_L8s_v2"
	AzureSKUNameStandardL8SV3         AzureSKUName = "Standard_L8s_v3"
)

// PossibleAzureSKUNameValues returns the possible values for the AzureSKUName const type.
func PossibleAzureSKUNameValues() []AzureSKUName {
	return []AzureSKUName{
		AzureSKUNameDevNoSLAStandardD11V2,
		AzureSKUNameDevNoSLAStandardE2AV4,
		AzureSKUNameStandardD11V2,
		AzureSKUNameStandardD12V2,
		AzureSKUNameStandardD13V2,
		AzureSKUNameStandardD14V2,
		AzureSKUNameStandardD16DV5,
		AzureSKUNameStandardD32DV4,
		AzureSKUNameStandardD32DV5,
		AzureSKUNameStandardDS13V21TBPS,
		AzureSKUNameStandardDS13V22TBPS,
		AzureSKUNameStandardDS14V23TBPS,
		AzureSKUNameStandardDS14V24TBPS,
		AzureSKUNameStandardE16AV4,
		AzureSKUNameStandardE16AdsV5,
		AzureSKUNameStandardE16AsV43TBPS,
		AzureSKUNameStandardE16AsV44TBPS,
		AzureSKUNameStandardE16AsV53TBPS,
		AzureSKUNameStandardE16AsV54TBPS,
		AzureSKUNameStandardE16DV4,
		AzureSKUNameStandardE16DV5,
		AzureSKUNameStandardE16SV43TBPS,
		AzureSKUNameStandardE16SV44TBPS,
		AzureSKUNameStandardE16SV53TBPS,
		AzureSKUNameStandardE16SV54TBPS,
		AzureSKUNameStandardE2AV4,
		AzureSKUNameStandardE2AdsV5,
		AzureSKUNameStandardE2DV4,
		AzureSKUNameStandardE2DV5,
		AzureSKUNameStandardE4AV4,
		AzureSKUNameStandardE4AdsV5,
		AzureSKUNameStandardE4DV4,
		AzureSKUNameStandardE4DV5,
		AzureSKUNameStandardE64IV3,
		AzureSKUNameStandardE80IDsV4,
		AzureSKUNameStandardE8AV4,
		AzureSKUNameStandardE8AdsV5,
		AzureSKUNameStandardE8AsV41TBPS,
		AzureSKUNameStandardE8AsV42TBPS,
		AzureSKUNameStandardE8AsV51TBPS,
		AzureSKUNameStandardE8AsV52TBPS,
		AzureSKUNameStandardE8DV4,
		AzureSKUNameStandardE8DV5,
		AzureSKUNameStandardE8SV41TBPS,
		AzureSKUNameStandardE8SV42TBPS,
		AzureSKUNameStandardE8SV51TBPS,
		AzureSKUNameStandardE8SV52TBPS,
		AzureSKUNameStandardEC16AdsV5,
		AzureSKUNameStandardEC16AsV53TBPS,
		AzureSKUNameStandardEC16AsV54TBPS,
		AzureSKUNameStandardEC8AdsV5,
		AzureSKUNameStandardEC8AsV51TBPS,
		AzureSKUNameStandardEC8AsV52TBPS,
		AzureSKUNameStandardL16AsV3,
		AzureSKUNameStandardL16S,
		AzureSKUNameStandardL16SV2,
		AzureSKUNameStandardL16SV3,
		AzureSKUNameStandardL32AsV3,
		AzureSKUNameStandardL32SV3,
		AzureSKUNameStandardL4S,
		AzureSKUNameStandardL8AsV3,
		AzureSKUNameStandardL8S,
		AzureSKUNameStandardL8SV2,
		AzureSKUNameStandardL8SV3,
	}
}

// AzureSKUTier - SKU tier.
type AzureSKUTier string

const (
	AzureSKUTierBasic    AzureSKUTier = "Basic"
	AzureSKUTierStandard AzureSKUTier = "Standard"
)

// PossibleAzureSKUTierValues returns the possible values for the AzureSKUTier const type.
func PossibleAzureSKUTierValues() []AzureSKUTier {
	return []AzureSKUTier{
		AzureSKUTierBasic,
		AzureSKUTierStandard,
	}
}

// AzureScaleType - Scale type.
type AzureScaleType string

const (
	AzureScaleTypeAutomatic AzureScaleType = "automatic"
	AzureScaleTypeManual    AzureScaleType = "manual"
	AzureScaleTypeNone      AzureScaleType = "none"
)

// PossibleAzureScaleTypeValues returns the possible values for the AzureScaleType const type.
func PossibleAzureScaleTypeValues() []AzureScaleType {
	return []AzureScaleType{
		AzureScaleTypeAutomatic,
		AzureScaleTypeManual,
		AzureScaleTypeNone,
	}
}

// BlobStorageEventType - The name of blob storage event type to process.
type BlobStorageEventType string

const (
	BlobStorageEventTypeMicrosoftStorageBlobCreated BlobStorageEventType = "Microsoft.Storage.BlobCreated"
	BlobStorageEventTypeMicrosoftStorageBlobRenamed BlobStorageEventType = "Microsoft.Storage.BlobRenamed"
)

// PossibleBlobStorageEventTypeValues returns the possible values for the BlobStorageEventType const type.
func PossibleBlobStorageEventTypeValues() []BlobStorageEventType {
	return []BlobStorageEventType{
		BlobStorageEventTypeMicrosoftStorageBlobCreated,
		BlobStorageEventTypeMicrosoftStorageBlobRenamed,
	}
}

type CallerRole string

const (
	CallerRoleAdmin CallerRole = "Admin"
	CallerRoleNone  CallerRole = "None"
)

// PossibleCallerRoleValues returns the possible values for the CallerRole const type.
func PossibleCallerRoleValues() []CallerRole {
	return []CallerRole{
		CallerRoleAdmin,
		CallerRoleNone,
	}
}

// ClusterNetworkAccessFlag - Whether or not to restrict outbound network access. Value is optional but if passed in, must
// be 'Enabled' or 'Disabled'
type ClusterNetworkAccessFlag string

const (
	ClusterNetworkAccessFlagDisabled ClusterNetworkAccessFlag = "Disabled"
	ClusterNetworkAccessFlagEnabled  ClusterNetworkAccessFlag = "Enabled"
)

// PossibleClusterNetworkAccessFlagValues returns the possible values for the ClusterNetworkAccessFlag const type.
func PossibleClusterNetworkAccessFlagValues() []ClusterNetworkAccessFlag {
	return []ClusterNetworkAccessFlag{
		ClusterNetworkAccessFlagDisabled,
		ClusterNetworkAccessFlagEnabled,
	}
}

// ClusterPrincipalRole - Cluster principal role.
type ClusterPrincipalRole string

const (
	ClusterPrincipalRoleAllDatabasesAdmin  ClusterPrincipalRole = "AllDatabasesAdmin"
	ClusterPrincipalRoleAllDatabasesViewer ClusterPrincipalRole = "AllDatabasesViewer"
)

// PossibleClusterPrincipalRoleValues returns the possible values for the ClusterPrincipalRole const type.
func PossibleClusterPrincipalRoleValues() []ClusterPrincipalRole {
	return []ClusterPrincipalRole{
		ClusterPrincipalRoleAllDatabasesAdmin,
		ClusterPrincipalRoleAllDatabasesViewer,
	}
}

// Compression - The compression type
type Compression string

const (
	CompressionGZip Compression = "GZip"
	CompressionNone Compression = "None"
)

// PossibleCompressionValues returns the possible values for the Compression const type.
func PossibleCompressionValues() []Compression {
	return []Compression{
		CompressionGZip,
		CompressionNone,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// DataConnectionKind - Kind of the endpoint for the data connection
type DataConnectionKind string

const (
	DataConnectionKindCosmosDb  DataConnectionKind = "CosmosDb"
	DataConnectionKindEventGrid DataConnectionKind = "EventGrid"
	DataConnectionKindEventHub  DataConnectionKind = "EventHub"
	DataConnectionKindIotHub    DataConnectionKind = "IotHub"
)

// PossibleDataConnectionKindValues returns the possible values for the DataConnectionKind const type.
func PossibleDataConnectionKindValues() []DataConnectionKind {
	return []DataConnectionKind{
		DataConnectionKindCosmosDb,
		DataConnectionKindEventGrid,
		DataConnectionKindEventHub,
		DataConnectionKindIotHub,
	}
}

// DatabasePrincipalRole - Database principal role.
type DatabasePrincipalRole string

const (
	DatabasePrincipalRoleAdmin              DatabasePrincipalRole = "Admin"
	DatabasePrincipalRoleIngestor           DatabasePrincipalRole = "Ingestor"
	DatabasePrincipalRoleMonitor            DatabasePrincipalRole = "Monitor"
	DatabasePrincipalRoleUnrestrictedViewer DatabasePrincipalRole = "UnrestrictedViewer"
	DatabasePrincipalRoleUser               DatabasePrincipalRole = "User"
	DatabasePrincipalRoleViewer             DatabasePrincipalRole = "Viewer"
)

// PossibleDatabasePrincipalRoleValues returns the possible values for the DatabasePrincipalRole const type.
func PossibleDatabasePrincipalRoleValues() []DatabasePrincipalRole {
	return []DatabasePrincipalRole{
		DatabasePrincipalRoleAdmin,
		DatabasePrincipalRoleIngestor,
		DatabasePrincipalRoleMonitor,
		DatabasePrincipalRoleUnrestrictedViewer,
		DatabasePrincipalRoleUser,
		DatabasePrincipalRoleViewer,
	}
}

// DatabasePrincipalType - Database principal type.
type DatabasePrincipalType string

const (
	DatabasePrincipalTypeApp   DatabasePrincipalType = "App"
	DatabasePrincipalTypeGroup DatabasePrincipalType = "Group"
	DatabasePrincipalTypeUser  DatabasePrincipalType = "User"
)

// PossibleDatabasePrincipalTypeValues returns the possible values for the DatabasePrincipalType const type.
func PossibleDatabasePrincipalTypeValues() []DatabasePrincipalType {
	return []DatabasePrincipalType{
		DatabasePrincipalTypeApp,
		DatabasePrincipalTypeGroup,
		DatabasePrincipalTypeUser,
	}
}

// DatabaseRouting - Indication for database routing information from the data connection, by default only database routing
// information is allowed
type DatabaseRouting string

const (
	DatabaseRoutingMulti  DatabaseRouting = "Multi"
	DatabaseRoutingSingle DatabaseRouting = "Single"
)

// PossibleDatabaseRoutingValues returns the possible values for the DatabaseRouting const type.
func PossibleDatabaseRoutingValues() []DatabaseRouting {
	return []DatabaseRouting{
		DatabaseRoutingMulti,
		DatabaseRoutingSingle,
	}
}

// DatabaseShareOrigin - The origin of the following setup.
type DatabaseShareOrigin string

const (
	DatabaseShareOriginDataShare DatabaseShareOrigin = "DataShare"
	DatabaseShareOriginDirect    DatabaseShareOrigin = "Direct"
	DatabaseShareOriginOther     DatabaseShareOrigin = "Other"
)

// PossibleDatabaseShareOriginValues returns the possible values for the DatabaseShareOrigin const type.
func PossibleDatabaseShareOriginValues() []DatabaseShareOrigin {
	return []DatabaseShareOrigin{
		DatabaseShareOriginDataShare,
		DatabaseShareOriginDirect,
		DatabaseShareOriginOther,
	}
}

// DefaultPrincipalsModificationKind - The default principals modification kind
type DefaultPrincipalsModificationKind string

const (
	DefaultPrincipalsModificationKindNone    DefaultPrincipalsModificationKind = "None"
	DefaultPrincipalsModificationKindReplace DefaultPrincipalsModificationKind = "Replace"
	DefaultPrincipalsModificationKindUnion   DefaultPrincipalsModificationKind = "Union"
)

// PossibleDefaultPrincipalsModificationKindValues returns the possible values for the DefaultPrincipalsModificationKind const type.
func PossibleDefaultPrincipalsModificationKindValues() []DefaultPrincipalsModificationKind {
	return []DefaultPrincipalsModificationKind{
		DefaultPrincipalsModificationKindNone,
		DefaultPrincipalsModificationKindReplace,
		DefaultPrincipalsModificationKindUnion,
	}
}

// EngineType - The engine type
type EngineType string

const (
	EngineTypeV2 EngineType = "V2"
	EngineTypeV3 EngineType = "V3"
)

// PossibleEngineTypeValues returns the possible values for the EngineType const type.
func PossibleEngineTypeValues() []EngineType {
	return []EngineType{
		EngineTypeV2,
		EngineTypeV3,
	}
}

// EventGridDataFormat - The data format of the message. Optionally the data format can be added to each message.
type EventGridDataFormat string

const (
	EventGridDataFormatAPACHEAVRO EventGridDataFormat = "APACHEAVRO"
	EventGridDataFormatAVRO       EventGridDataFormat = "AVRO"
	EventGridDataFormatCSV        EventGridDataFormat = "CSV"
	EventGridDataFormatJSON       EventGridDataFormat = "JSON"
	EventGridDataFormatMULTIJSON  EventGridDataFormat = "MULTIJSON"
	EventGridDataFormatORC        EventGridDataFormat = "ORC"
	EventGridDataFormatPARQUET    EventGridDataFormat = "PARQUET"
	EventGridDataFormatPSV        EventGridDataFormat = "PSV"
	EventGridDataFormatRAW        EventGridDataFormat = "RAW"
	EventGridDataFormatSCSV       EventGridDataFormat = "SCSV"
	EventGridDataFormatSINGLEJSON EventGridDataFormat = "SINGLEJSON"
	EventGridDataFormatSOHSV      EventGridDataFormat = "SOHSV"
	EventGridDataFormatTSV        EventGridDataFormat = "TSV"
	EventGridDataFormatTSVE       EventGridDataFormat = "TSVE"
	EventGridDataFormatTXT        EventGridDataFormat = "TXT"
	EventGridDataFormatW3CLOGFILE EventGridDataFormat = "W3CLOGFILE"
)

// PossibleEventGridDataFormatValues returns the possible values for the EventGridDataFormat const type.
func PossibleEventGridDataFormatValues() []EventGridDataFormat {
	return []EventGridDataFormat{
		EventGridDataFormatAPACHEAVRO,
		EventGridDataFormatAVRO,
		EventGridDataFormatCSV,
		EventGridDataFormatJSON,
		EventGridDataFormatMULTIJSON,
		EventGridDataFormatORC,
		EventGridDataFormatPARQUET,
		EventGridDataFormatPSV,
		EventGridDataFormatRAW,
		EventGridDataFormatSCSV,
		EventGridDataFormatSINGLEJSON,
		EventGridDataFormatSOHSV,
		EventGridDataFormatTSV,
		EventGridDataFormatTSVE,
		EventGridDataFormatTXT,
		EventGridDataFormatW3CLOGFILE,
	}
}

// EventHubDataFormat - The data format of the message. Optionally the data format can be added to each message.
type EventHubDataFormat string

const (
	EventHubDataFormatAPACHEAVRO EventHubDataFormat = "APACHEAVRO"
	EventHubDataFormatAVRO       EventHubDataFormat = "AVRO"
	EventHubDataFormatCSV        EventHubDataFormat = "CSV"
	EventHubDataFormatJSON       EventHubDataFormat = "JSON"
	EventHubDataFormatMULTIJSON  EventHubDataFormat = "MULTIJSON"
	EventHubDataFormatORC        EventHubDataFormat = "ORC"
	EventHubDataFormatPARQUET    EventHubDataFormat = "PARQUET"
	EventHubDataFormatPSV        EventHubDataFormat = "PSV"
	EventHubDataFormatRAW        EventHubDataFormat = "RAW"
	EventHubDataFormatSCSV       EventHubDataFormat = "SCSV"
	EventHubDataFormatSINGLEJSON EventHubDataFormat = "SINGLEJSON"
	EventHubDataFormatSOHSV      EventHubDataFormat = "SOHSV"
	EventHubDataFormatTSV        EventHubDataFormat = "TSV"
	EventHubDataFormatTSVE       EventHubDataFormat = "TSVE"
	EventHubDataFormatTXT        EventHubDataFormat = "TXT"
	EventHubDataFormatW3CLOGFILE EventHubDataFormat = "W3CLOGFILE"
)

// PossibleEventHubDataFormatValues returns the possible values for the EventHubDataFormat const type.
func PossibleEventHubDataFormatValues() []EventHubDataFormat {
	return []EventHubDataFormat{
		EventHubDataFormatAPACHEAVRO,
		EventHubDataFormatAVRO,
		EventHubDataFormatCSV,
		EventHubDataFormatJSON,
		EventHubDataFormatMULTIJSON,
		EventHubDataFormatORC,
		EventHubDataFormatPARQUET,
		EventHubDataFormatPSV,
		EventHubDataFormatRAW,
		EventHubDataFormatSCSV,
		EventHubDataFormatSINGLEJSON,
		EventHubDataFormatSOHSV,
		EventHubDataFormatTSV,
		EventHubDataFormatTSVE,
		EventHubDataFormatTXT,
		EventHubDataFormatW3CLOGFILE,
	}
}

// IdentityType - The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created
// identity and a set of user-assigned identities. The type 'None' will remove all
// identities.
type IdentityType string

const (
	IdentityTypeNone                       IdentityType = "None"
	IdentityTypeSystemAssigned             IdentityType = "SystemAssigned"
	IdentityTypeSystemAssignedUserAssigned IdentityType = "SystemAssigned, UserAssigned"
	IdentityTypeUserAssigned               IdentityType = "UserAssigned"
)

// PossibleIdentityTypeValues returns the possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{
		IdentityTypeNone,
		IdentityTypeSystemAssigned,
		IdentityTypeSystemAssignedUserAssigned,
		IdentityTypeUserAssigned,
	}
}

// IotHubDataFormat - The data format of the message. Optionally the data format can be added to each message.
type IotHubDataFormat string

const (
	IotHubDataFormatAPACHEAVRO IotHubDataFormat = "APACHEAVRO"
	IotHubDataFormatAVRO       IotHubDataFormat = "AVRO"
	IotHubDataFormatCSV        IotHubDataFormat = "CSV"
	IotHubDataFormatJSON       IotHubDataFormat = "JSON"
	IotHubDataFormatMULTIJSON  IotHubDataFormat = "MULTIJSON"
	IotHubDataFormatORC        IotHubDataFormat = "ORC"
	IotHubDataFormatPARQUET    IotHubDataFormat = "PARQUET"
	IotHubDataFormatPSV        IotHubDataFormat = "PSV"
	IotHubDataFormatRAW        IotHubDataFormat = "RAW"
	IotHubDataFormatSCSV       IotHubDataFormat = "SCSV"
	IotHubDataFormatSINGLEJSON IotHubDataFormat = "SINGLEJSON"
	IotHubDataFormatSOHSV      IotHubDataFormat = "SOHSV"
	IotHubDataFormatTSV        IotHubDataFormat = "TSV"
	IotHubDataFormatTSVE       IotHubDataFormat = "TSVE"
	IotHubDataFormatTXT        IotHubDataFormat = "TXT"
	IotHubDataFormatW3CLOGFILE IotHubDataFormat = "W3CLOGFILE"
)

// PossibleIotHubDataFormatValues returns the possible values for the IotHubDataFormat const type.
func PossibleIotHubDataFormatValues() []IotHubDataFormat {
	return []IotHubDataFormat{
		IotHubDataFormatAPACHEAVRO,
		IotHubDataFormatAVRO,
		IotHubDataFormatCSV,
		IotHubDataFormatJSON,
		IotHubDataFormatMULTIJSON,
		IotHubDataFormatORC,
		IotHubDataFormatPARQUET,
		IotHubDataFormatPSV,
		IotHubDataFormatRAW,
		IotHubDataFormatSCSV,
		IotHubDataFormatSINGLEJSON,
		IotHubDataFormatSOHSV,
		IotHubDataFormatTSV,
		IotHubDataFormatTSVE,
		IotHubDataFormatTXT,
		IotHubDataFormatW3CLOGFILE,
	}
}

// Kind - Kind of the database
type Kind string

const (
	KindReadOnlyFollowing Kind = "ReadOnlyFollowing"
	KindReadWrite         Kind = "ReadWrite"
)

// PossibleKindValues returns the possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{
		KindReadOnlyFollowing,
		KindReadWrite,
	}
}

// Language - The language name, for example Python.
type Language string

const (
	LanguagePython Language = "Python"
)

// PossibleLanguageValues returns the possible values for the Language const type.
func PossibleLanguageValues() []Language {
	return []Language{
		LanguagePython,
	}
}

// LanguageExtensionImageName - Language extension image name.
type LanguageExtensionImageName string

const (
	LanguageExtensionImageNamePython3108        LanguageExtensionImageName = "Python3_10_8"
	LanguageExtensionImageNamePython3108DL      LanguageExtensionImageName = "Python3_10_8_DL"
	LanguageExtensionImageNamePython365         LanguageExtensionImageName = "Python3_6_5"
	LanguageExtensionImageNamePythonCustomImage LanguageExtensionImageName = "PythonCustomImage"
	LanguageExtensionImageNameR                 LanguageExtensionImageName = "R"
)

// PossibleLanguageExtensionImageNameValues returns the possible values for the LanguageExtensionImageName const type.
func PossibleLanguageExtensionImageNameValues() []LanguageExtensionImageName {
	return []LanguageExtensionImageName{
		LanguageExtensionImageNamePython3108,
		LanguageExtensionImageNamePython3108DL,
		LanguageExtensionImageNamePython365,
		LanguageExtensionImageNamePythonCustomImage,
		LanguageExtensionImageNameR,
	}
}

// LanguageExtensionName - Language extension that can run within KQL query.
type LanguageExtensionName string

const (
	LanguageExtensionNamePYTHON LanguageExtensionName = "PYTHON"
	LanguageExtensionNameR      LanguageExtensionName = "R"
)

// PossibleLanguageExtensionNameValues returns the possible values for the LanguageExtensionName const type.
func PossibleLanguageExtensionNameValues() []LanguageExtensionName {
	return []LanguageExtensionName{
		LanguageExtensionNamePYTHON,
		LanguageExtensionNameR,
	}
}

// MigrationClusterRole - The role of the cluster in the migration process.
type MigrationClusterRole string

const (
	MigrationClusterRoleDestination MigrationClusterRole = "Destination"
	MigrationClusterRoleSource      MigrationClusterRole = "Source"
)

// PossibleMigrationClusterRoleValues returns the possible values for the MigrationClusterRole const type.
func PossibleMigrationClusterRoleValues() []MigrationClusterRole {
	return []MigrationClusterRole{
		MigrationClusterRoleDestination,
		MigrationClusterRoleSource,
	}
}

// PrincipalType - Principal type.
type PrincipalType string

const (
	PrincipalTypeApp   PrincipalType = "App"
	PrincipalTypeGroup PrincipalType = "Group"
	PrincipalTypeUser  PrincipalType = "User"
)

// PossiblePrincipalTypeValues returns the possible values for the PrincipalType const type.
func PossiblePrincipalTypeValues() []PrincipalType {
	return []PrincipalType{
		PrincipalTypeApp,
		PrincipalTypeGroup,
		PrincipalTypeUser,
	}
}

// PrincipalsModificationKind - The principals modification kind of the database
type PrincipalsModificationKind string

const (
	PrincipalsModificationKindNone    PrincipalsModificationKind = "None"
	PrincipalsModificationKindReplace PrincipalsModificationKind = "Replace"
	PrincipalsModificationKindUnion   PrincipalsModificationKind = "Union"
)

// PossiblePrincipalsModificationKindValues returns the possible values for the PrincipalsModificationKind const type.
func PossiblePrincipalsModificationKindValues() []PrincipalsModificationKind {
	return []PrincipalsModificationKind{
		PrincipalsModificationKindNone,
		PrincipalsModificationKindReplace,
		PrincipalsModificationKindUnion,
	}
}

// ProvisioningState - The provisioned state of the resource.
type ProvisioningState string

const (
	ProvisioningStateCanceled  ProvisioningState = "Canceled"
	ProvisioningStateCreating  ProvisioningState = "Creating"
	ProvisioningStateDeleting  ProvisioningState = "Deleting"
	ProvisioningStateFailed    ProvisioningState = "Failed"
	ProvisioningStateMoving    ProvisioningState = "Moving"
	ProvisioningStateRunning   ProvisioningState = "Running"
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateCanceled,
		ProvisioningStateCreating,
		ProvisioningStateDeleting,
		ProvisioningStateFailed,
		ProvisioningStateMoving,
		ProvisioningStateRunning,
		ProvisioningStateSucceeded,
	}
}

// PublicIPType - Indicates what public IP type to create - IPv4 (default), or DualStack (both IPv4 and IPv6)
type PublicIPType string

const (
	PublicIPTypeDualStack PublicIPType = "DualStack"
	PublicIPTypeIPv4      PublicIPType = "IPv4"
)

// PossiblePublicIPTypeValues returns the possible values for the PublicIPType const type.
func PossiblePublicIPTypeValues() []PublicIPType {
	return []PublicIPType{
		PublicIPTypeDualStack,
		PublicIPTypeIPv4,
	}
}

// PublicNetworkAccess - Public network access to the cluster is enabled by default. When disabled, only private endpoint
// connection to the cluster is allowed
type PublicNetworkAccess string

const (
	PublicNetworkAccessDisabled PublicNetworkAccess = "Disabled"
	PublicNetworkAccessEnabled  PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns the possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{
		PublicNetworkAccessDisabled,
		PublicNetworkAccessEnabled,
	}
}

// Reason - Message providing the reason why the given name is invalid.
type Reason string

const (
	ReasonAlreadyExists Reason = "AlreadyExists"
	ReasonInvalid       Reason = "Invalid"
)

// PossibleReasonValues returns the possible values for the Reason const type.
func PossibleReasonValues() []Reason {
	return []Reason{
		ReasonAlreadyExists,
		ReasonInvalid,
	}
}

// State - The state of the resource.
type State string

const (
	StateCreating    State = "Creating"
	StateDeleted     State = "Deleted"
	StateDeleting    State = "Deleting"
	StateMigrated    State = "Migrated"
	StateRunning     State = "Running"
	StateStarting    State = "Starting"
	StateStopped     State = "Stopped"
	StateStopping    State = "Stopping"
	StateUnavailable State = "Unavailable"
	StateUpdating    State = "Updating"
)

// PossibleStateValues returns the possible values for the State const type.
func PossibleStateValues() []State {
	return []State{
		StateCreating,
		StateDeleted,
		StateDeleting,
		StateMigrated,
		StateRunning,
		StateStarting,
		StateStopped,
		StateStopping,
		StateUnavailable,
		StateUpdating,
	}
}

// Status - The status of operation.
type Status string

const (
	StatusCanceled  Status = "Canceled"
	StatusFailed    Status = "Failed"
	StatusRunning   Status = "Running"
	StatusSucceeded Status = "Succeeded"
)

// PossibleStatusValues returns the possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{
		StatusCanceled,
		StatusFailed,
		StatusRunning,
		StatusSucceeded,
	}
}

// Type - The type of resource, for instance Microsoft.Kusto/clusters/databases.
type Type string

const (
	TypeMicrosoftKustoClustersAttachedDatabaseConfigurations Type = "Microsoft.Kusto/clusters/attachedDatabaseConfigurations"
	TypeMicrosoftKustoClustersDatabases                      Type = "Microsoft.Kusto/clusters/databases"
)

// PossibleTypeValues returns the possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{
		TypeMicrosoftKustoClustersAttachedDatabaseConfigurations,
		TypeMicrosoftKustoClustersDatabases,
	}
}

// VnetState - When enabled, the cluster is deployed into the configured subnet, when disabled it will be removed from the
// subnet.
type VnetState string

const (
	VnetStateDisabled VnetState = "Disabled"
	VnetStateEnabled  VnetState = "Enabled"
)

// PossibleVnetStateValues returns the possible values for the VnetState const type.
func PossibleVnetStateValues() []VnetState {
	return []VnetState{
		VnetStateDisabled,
		VnetStateEnabled,
	}
}
