//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armmonitor.ClientFactory type.
type ServerFactory struct {
	ActionGroupsServer                    ActionGroupsServer
	ActivityLogAlertsServer               ActivityLogAlertsServer
	ActivityLogsServer                    ActivityLogsServer
	AlertRuleIncidentsServer              AlertRuleIncidentsServer
	AlertRulesServer                      AlertRulesServer
	AutoscaleSettingsServer               AutoscaleSettingsServer
	AzureMonitorWorkspacesServer          AzureMonitorWorkspacesServer
	BaselinesServer                       BaselinesServer
	DataCollectionEndpointsServer         DataCollectionEndpointsServer
	DataCollectionRuleAssociationsServer  DataCollectionRuleAssociationsServer
	DataCollectionRulesServer             DataCollectionRulesServer
	DiagnosticSettingsCategoryServer      DiagnosticSettingsCategoryServer
	DiagnosticSettingsServer              DiagnosticSettingsServer
	EventCategoriesServer                 EventCategoriesServer
	LogProfilesServer                     LogProfilesServer
	MetricAlertsServer                    MetricAlertsServer
	MetricAlertsStatusServer              MetricAlertsStatusServer
	MetricDefinitionsServer               MetricDefinitionsServer
	MetricNamespacesServer                MetricNamespacesServer
	MetricsServer                         MetricsServer
	OperationsServer                      OperationsServer
	OperationsForMonitorServer            OperationsForMonitorServer
	PredictiveMetricServer                PredictiveMetricServer
	PrivateEndpointConnectionsServer      PrivateEndpointConnectionsServer
	PrivateLinkResourcesServer            PrivateLinkResourcesServer
	PrivateLinkScopeOperationStatusServer PrivateLinkScopeOperationStatusServer
	PrivateLinkScopedResourcesServer      PrivateLinkScopedResourcesServer
	PrivateLinkScopesServer               PrivateLinkScopesServer
	ScheduledQueryRulesServer             ScheduledQueryRulesServer
	TenantActionGroupsServer              TenantActionGroupsServer
	TenantActivityLogsServer              TenantActivityLogsServer
	VMInsightsServer                      VMInsightsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armmonitor.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armmonitor.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                     *ServerFactory
	trMu                                    sync.Mutex
	trActionGroupsServer                    *ActionGroupsServerTransport
	trActivityLogAlertsServer               *ActivityLogAlertsServerTransport
	trActivityLogsServer                    *ActivityLogsServerTransport
	trAlertRuleIncidentsServer              *AlertRuleIncidentsServerTransport
	trAlertRulesServer                      *AlertRulesServerTransport
	trAutoscaleSettingsServer               *AutoscaleSettingsServerTransport
	trAzureMonitorWorkspacesServer          *AzureMonitorWorkspacesServerTransport
	trBaselinesServer                       *BaselinesServerTransport
	trDataCollectionEndpointsServer         *DataCollectionEndpointsServerTransport
	trDataCollectionRuleAssociationsServer  *DataCollectionRuleAssociationsServerTransport
	trDataCollectionRulesServer             *DataCollectionRulesServerTransport
	trDiagnosticSettingsCategoryServer      *DiagnosticSettingsCategoryServerTransport
	trDiagnosticSettingsServer              *DiagnosticSettingsServerTransport
	trEventCategoriesServer                 *EventCategoriesServerTransport
	trLogProfilesServer                     *LogProfilesServerTransport
	trMetricAlertsServer                    *MetricAlertsServerTransport
	trMetricAlertsStatusServer              *MetricAlertsStatusServerTransport
	trMetricDefinitionsServer               *MetricDefinitionsServerTransport
	trMetricNamespacesServer                *MetricNamespacesServerTransport
	trMetricsServer                         *MetricsServerTransport
	trOperationsServer                      *OperationsServerTransport
	trOperationsForMonitorServer            *OperationsForMonitorServerTransport
	trPredictiveMetricServer                *PredictiveMetricServerTransport
	trPrivateEndpointConnectionsServer      *PrivateEndpointConnectionsServerTransport
	trPrivateLinkResourcesServer            *PrivateLinkResourcesServerTransport
	trPrivateLinkScopeOperationStatusServer *PrivateLinkScopeOperationStatusServerTransport
	trPrivateLinkScopedResourcesServer      *PrivateLinkScopedResourcesServerTransport
	trPrivateLinkScopesServer               *PrivateLinkScopesServerTransport
	trScheduledQueryRulesServer             *ScheduledQueryRulesServerTransport
	trTenantActionGroupsServer              *TenantActionGroupsServerTransport
	trTenantActivityLogsServer              *TenantActivityLogsServerTransport
	trVMInsightsServer                      *VMInsightsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "ActionGroupsClient":
		initServer(s, &s.trActionGroupsServer, func() *ActionGroupsServerTransport { return NewActionGroupsServerTransport(&s.srv.ActionGroupsServer) })
		resp, err = s.trActionGroupsServer.Do(req)
	case "ActivityLogAlertsClient":
		initServer(s, &s.trActivityLogAlertsServer, func() *ActivityLogAlertsServerTransport {
			return NewActivityLogAlertsServerTransport(&s.srv.ActivityLogAlertsServer)
		})
		resp, err = s.trActivityLogAlertsServer.Do(req)
	case "ActivityLogsClient":
		initServer(s, &s.trActivityLogsServer, func() *ActivityLogsServerTransport { return NewActivityLogsServerTransport(&s.srv.ActivityLogsServer) })
		resp, err = s.trActivityLogsServer.Do(req)
	case "AlertRuleIncidentsClient":
		initServer(s, &s.trAlertRuleIncidentsServer, func() *AlertRuleIncidentsServerTransport {
			return NewAlertRuleIncidentsServerTransport(&s.srv.AlertRuleIncidentsServer)
		})
		resp, err = s.trAlertRuleIncidentsServer.Do(req)
	case "AlertRulesClient":
		initServer(s, &s.trAlertRulesServer, func() *AlertRulesServerTransport { return NewAlertRulesServerTransport(&s.srv.AlertRulesServer) })
		resp, err = s.trAlertRulesServer.Do(req)
	case "AutoscaleSettingsClient":
		initServer(s, &s.trAutoscaleSettingsServer, func() *AutoscaleSettingsServerTransport {
			return NewAutoscaleSettingsServerTransport(&s.srv.AutoscaleSettingsServer)
		})
		resp, err = s.trAutoscaleSettingsServer.Do(req)
	case "AzureMonitorWorkspacesClient":
		initServer(s, &s.trAzureMonitorWorkspacesServer, func() *AzureMonitorWorkspacesServerTransport {
			return NewAzureMonitorWorkspacesServerTransport(&s.srv.AzureMonitorWorkspacesServer)
		})
		resp, err = s.trAzureMonitorWorkspacesServer.Do(req)
	case "BaselinesClient":
		initServer(s, &s.trBaselinesServer, func() *BaselinesServerTransport { return NewBaselinesServerTransport(&s.srv.BaselinesServer) })
		resp, err = s.trBaselinesServer.Do(req)
	case "DataCollectionEndpointsClient":
		initServer(s, &s.trDataCollectionEndpointsServer, func() *DataCollectionEndpointsServerTransport {
			return NewDataCollectionEndpointsServerTransport(&s.srv.DataCollectionEndpointsServer)
		})
		resp, err = s.trDataCollectionEndpointsServer.Do(req)
	case "DataCollectionRuleAssociationsClient":
		initServer(s, &s.trDataCollectionRuleAssociationsServer, func() *DataCollectionRuleAssociationsServerTransport {
			return NewDataCollectionRuleAssociationsServerTransport(&s.srv.DataCollectionRuleAssociationsServer)
		})
		resp, err = s.trDataCollectionRuleAssociationsServer.Do(req)
	case "DataCollectionRulesClient":
		initServer(s, &s.trDataCollectionRulesServer, func() *DataCollectionRulesServerTransport {
			return NewDataCollectionRulesServerTransport(&s.srv.DataCollectionRulesServer)
		})
		resp, err = s.trDataCollectionRulesServer.Do(req)
	case "DiagnosticSettingsCategoryClient":
		initServer(s, &s.trDiagnosticSettingsCategoryServer, func() *DiagnosticSettingsCategoryServerTransport {
			return NewDiagnosticSettingsCategoryServerTransport(&s.srv.DiagnosticSettingsCategoryServer)
		})
		resp, err = s.trDiagnosticSettingsCategoryServer.Do(req)
	case "DiagnosticSettingsClient":
		initServer(s, &s.trDiagnosticSettingsServer, func() *DiagnosticSettingsServerTransport {
			return NewDiagnosticSettingsServerTransport(&s.srv.DiagnosticSettingsServer)
		})
		resp, err = s.trDiagnosticSettingsServer.Do(req)
	case "EventCategoriesClient":
		initServer(s, &s.trEventCategoriesServer, func() *EventCategoriesServerTransport {
			return NewEventCategoriesServerTransport(&s.srv.EventCategoriesServer)
		})
		resp, err = s.trEventCategoriesServer.Do(req)
	case "LogProfilesClient":
		initServer(s, &s.trLogProfilesServer, func() *LogProfilesServerTransport { return NewLogProfilesServerTransport(&s.srv.LogProfilesServer) })
		resp, err = s.trLogProfilesServer.Do(req)
	case "MetricAlertsClient":
		initServer(s, &s.trMetricAlertsServer, func() *MetricAlertsServerTransport { return NewMetricAlertsServerTransport(&s.srv.MetricAlertsServer) })
		resp, err = s.trMetricAlertsServer.Do(req)
	case "MetricAlertsStatusClient":
		initServer(s, &s.trMetricAlertsStatusServer, func() *MetricAlertsStatusServerTransport {
			return NewMetricAlertsStatusServerTransport(&s.srv.MetricAlertsStatusServer)
		})
		resp, err = s.trMetricAlertsStatusServer.Do(req)
	case "MetricDefinitionsClient":
		initServer(s, &s.trMetricDefinitionsServer, func() *MetricDefinitionsServerTransport {
			return NewMetricDefinitionsServerTransport(&s.srv.MetricDefinitionsServer)
		})
		resp, err = s.trMetricDefinitionsServer.Do(req)
	case "MetricNamespacesClient":
		initServer(s, &s.trMetricNamespacesServer, func() *MetricNamespacesServerTransport {
			return NewMetricNamespacesServerTransport(&s.srv.MetricNamespacesServer)
		})
		resp, err = s.trMetricNamespacesServer.Do(req)
	case "MetricsClient":
		initServer(s, &s.trMetricsServer, func() *MetricsServerTransport { return NewMetricsServerTransport(&s.srv.MetricsServer) })
		resp, err = s.trMetricsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "OperationsForMonitorClient":
		initServer(s, &s.trOperationsForMonitorServer, func() *OperationsForMonitorServerTransport {
			return NewOperationsForMonitorServerTransport(&s.srv.OperationsForMonitorServer)
		})
		resp, err = s.trOperationsForMonitorServer.Do(req)
	case "PredictiveMetricClient":
		initServer(s, &s.trPredictiveMetricServer, func() *PredictiveMetricServerTransport {
			return NewPredictiveMetricServerTransport(&s.srv.PredictiveMetricServer)
		})
		resp, err = s.trPredictiveMetricServer.Do(req)
	case "PrivateEndpointConnectionsClient":
		initServer(s, &s.trPrivateEndpointConnectionsServer, func() *PrivateEndpointConnectionsServerTransport {
			return NewPrivateEndpointConnectionsServerTransport(&s.srv.PrivateEndpointConnectionsServer)
		})
		resp, err = s.trPrivateEndpointConnectionsServer.Do(req)
	case "PrivateLinkResourcesClient":
		initServer(s, &s.trPrivateLinkResourcesServer, func() *PrivateLinkResourcesServerTransport {
			return NewPrivateLinkResourcesServerTransport(&s.srv.PrivateLinkResourcesServer)
		})
		resp, err = s.trPrivateLinkResourcesServer.Do(req)
	case "PrivateLinkScopeOperationStatusClient":
		initServer(s, &s.trPrivateLinkScopeOperationStatusServer, func() *PrivateLinkScopeOperationStatusServerTransport {
			return NewPrivateLinkScopeOperationStatusServerTransport(&s.srv.PrivateLinkScopeOperationStatusServer)
		})
		resp, err = s.trPrivateLinkScopeOperationStatusServer.Do(req)
	case "PrivateLinkScopedResourcesClient":
		initServer(s, &s.trPrivateLinkScopedResourcesServer, func() *PrivateLinkScopedResourcesServerTransport {
			return NewPrivateLinkScopedResourcesServerTransport(&s.srv.PrivateLinkScopedResourcesServer)
		})
		resp, err = s.trPrivateLinkScopedResourcesServer.Do(req)
	case "PrivateLinkScopesClient":
		initServer(s, &s.trPrivateLinkScopesServer, func() *PrivateLinkScopesServerTransport {
			return NewPrivateLinkScopesServerTransport(&s.srv.PrivateLinkScopesServer)
		})
		resp, err = s.trPrivateLinkScopesServer.Do(req)
	case "ScheduledQueryRulesClient":
		initServer(s, &s.trScheduledQueryRulesServer, func() *ScheduledQueryRulesServerTransport {
			return NewScheduledQueryRulesServerTransport(&s.srv.ScheduledQueryRulesServer)
		})
		resp, err = s.trScheduledQueryRulesServer.Do(req)
	case "TenantActionGroupsClient":
		initServer(s, &s.trTenantActionGroupsServer, func() *TenantActionGroupsServerTransport {
			return NewTenantActionGroupsServerTransport(&s.srv.TenantActionGroupsServer)
		})
		resp, err = s.trTenantActionGroupsServer.Do(req)
	case "TenantActivityLogsClient":
		initServer(s, &s.trTenantActivityLogsServer, func() *TenantActivityLogsServerTransport {
			return NewTenantActivityLogsServerTransport(&s.srv.TenantActivityLogsServer)
		})
		resp, err = s.trTenantActivityLogsServer.Do(req)
	case "VMInsightsClient":
		initServer(s, &s.trVMInsightsServer, func() *VMInsightsServerTransport { return NewVMInsightsServerTransport(&s.srv.VMInsightsServer) })
		resp, err = s.trVMInsightsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
