//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmonitor_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/monitor/armmonitor"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/listMetricAlert.json
func ExampleMetricAlertsClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMetricAlertsClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MetricAlertResourceCollection = armmonitor.MetricAlertResourceCollection{
		// 	Value: []*armmonitor.MetricAlertResource{
		// 		{
		// 			Type: to.Ptr("Microsoft.Insights/metricAlerts"),
		// 			ID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/providers/microsoft.insights/metricalerts/highcpu"),
		// 			Location: to.Ptr("global"),
		// 			Tags: map[string]*string{
		// 				"hidden-link:/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest": to.Ptr("Resource"),
		// 			},
		// 			Properties: &armmonitor.MetricAlertProperties{
		// 				Description: to.Ptr("This is the description of the rule1"),
		// 				Actions: []*armmonitor.MetricAlertAction{
		// 					{
		// 						ActionGroupID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
		// 						WebHookProperties: map[string]*string{
		// 							"key11": to.Ptr("value11"),
		// 							"key12": to.Ptr("value12"),
		// 						},
		// 				}},
		// 				Criteria: &armmonitor.MetricAlertSingleResourceMultipleMetricCriteria{
		// 					ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria),
		// 					AllOf: []*armmonitor.MetricCriteria{
		// 						{
		// 							Name: to.Ptr("High_CPU_80"),
		// 							CriterionType: to.Ptr(armmonitor.CriterionTypeStaticThresholdCriterion),
		// 							Dimensions: []*armmonitor.MetricDimension{
		// 							},
		// 							MetricName: to.Ptr("CustomMetric_\\Processor(_Total)\\% Processor Time"),
		// 							TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
		// 							Operator: to.Ptr(armmonitor.OperatorGreaterThan),
		// 							Threshold: to.Ptr[float64](80.5),
		// 					}},
		// 				},
		// 				Enabled: to.Ptr(true),
		// 				EvaluationFrequency: to.Ptr("Pt1m"),
		// 				Scopes: []*string{
		// 					to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme")},
		// 					Severity: to.Ptr[int32](3),
		// 					WindowSize: to.Ptr("Pt15m"),
		// 				},
		// 			},
		// 			{
		// 				Type: to.Ptr("Microsoft.Insights/metricAlerts"),
		// 				ID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/providers/microsoft.insights/metricalerts/mediumcpu"),
		// 				Location: to.Ptr("global"),
		// 				Tags: map[string]*string{
		// 					"hidden-link:/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest": to.Ptr("Resource"),
		// 				},
		// 				Properties: &armmonitor.MetricAlertProperties{
		// 					Description: to.Ptr("Med cpu alert"),
		// 					Actions: []*armmonitor.MetricAlertAction{
		// 						{
		// 							ActionGroupID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
		// 							WebHookProperties: map[string]*string{
		// 								"key11": to.Ptr("value11"),
		// 								"key12": to.Ptr("value12"),
		// 							},
		// 					}},
		// 					Criteria: &armmonitor.MetricAlertSingleResourceMultipleMetricCriteria{
		// 						ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria),
		// 						AllOf: []*armmonitor.MetricCriteria{
		// 							{
		// 								Name: to.Ptr("Medium_CPU_50"),
		// 								CriterionType: to.Ptr(armmonitor.CriterionTypeStaticThresholdCriterion),
		// 								Dimensions: []*armmonitor.MetricDimension{
		// 								},
		// 								MetricName: to.Ptr("CustomMetric_\\Processor(_Total)\\% Processor Time"),
		// 								TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
		// 								Operator: to.Ptr(armmonitor.OperatorGreaterThan),
		// 								Threshold: to.Ptr[float64](50.5),
		// 						}},
		// 					},
		// 					Enabled: to.Ptr(true),
		// 					EvaluationFrequency: to.Ptr("Pt1m"),
		// 					Scopes: []*string{
		// 						to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme")},
		// 						Severity: to.Ptr[int32](4),
		// 						WindowSize: to.Ptr("Pt15m"),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/getDynamicMetricAlertMultipleResource.json
func ExampleMetricAlertsClient_Get_getADynamicAlertRuleForMultipleResources() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricAlertsClient().Get(ctx, "gigtest", "MetricAlertOnMultipleResources", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricAlertResource = armmonitor.MetricAlertResource{
	// 	Type: to.Ptr("Microsoft.Insights/metricAlerts"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/providers/microsoft.insights/metricalerts/MetricAlertOnMultipleResources"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 		"hidden-link:/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest": to.Ptr("Resource"),
	// 	},
	// 	Properties: &armmonitor.MetricAlertProperties{
	// 		Description: to.Ptr("This is the description of the rule1"),
	// 		Actions: []*armmonitor.MetricAlertAction{
	// 			{
	// 				ActionGroupID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
	// 				WebHookProperties: map[string]*string{
	// 					"key11": to.Ptr("value11"),
	// 					"key12": to.Ptr("value12"),
	// 				},
	// 		}},
	// 		AutoMitigate: to.Ptr(false),
	// 		Criteria: &armmonitor.MetricAlertMultipleResourceMultipleMetricCriteria{
	// 			ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria),
	// 			AllOf: []armmonitor.MultiMetricCriteriaClassification{
	// 				&armmonitor.DynamicMetricCriteria{
	// 					Name: to.Ptr("High_CPU_80"),
	// 					CriterionType: to.Ptr(armmonitor.CriterionTypeDynamicThresholdCriterion),
	// 					Dimensions: []*armmonitor.MetricDimension{
	// 					},
	// 					MetricName: to.Ptr("Percentage CPU"),
	// 					MetricNamespace: to.Ptr("microsoft.compute/virtualmachines"),
	// 					TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
	// 					AlertSensitivity: to.Ptr(armmonitor.DynamicThresholdSensitivityMedium),
	// 					FailingPeriods: &armmonitor.DynamicThresholdFailingPeriods{
	// 						MinFailingPeriodsToAlert: to.Ptr[float32](4),
	// 						NumberOfEvaluationPeriods: to.Ptr[float32](4),
	// 					},
	// 					Operator: to.Ptr(armmonitor.DynamicThresholdOperatorGreaterOrLessThan),
	// 			}},
	// 		},
	// 		Enabled: to.Ptr(true),
	// 		EvaluationFrequency: to.Ptr("PT1M"),
	// 		Scopes: []*string{
	// 			to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme1"),
	// 			to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme2")},
	// 			Severity: to.Ptr[int32](3),
	// 			TargetResourceRegion: to.Ptr("southcentralus"),
	// 			TargetResourceType: to.Ptr("Microsoft.Compute/virtualMachines"),
	// 			WindowSize: to.Ptr("PT15M"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/getDynamicMetricAlertSingleResource.json
func ExampleMetricAlertsClient_Get_getADynamicAlertRuleForSingleResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricAlertsClient().Get(ctx, "gigtest", "chiricutin", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricAlertResource = armmonitor.MetricAlertResource{
	// 	Type: to.Ptr("Microsoft.Insights/metricAlerts"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/providers/microsoft.insights/metricalerts/chiricutin"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 		"hidden-link:/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest": to.Ptr("Resource"),
	// 	},
	// 	Properties: &armmonitor.MetricAlertProperties{
	// 		Description: to.Ptr("This is the description of the rule1"),
	// 		Actions: []*armmonitor.MetricAlertAction{
	// 			{
	// 				ActionGroupID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
	// 				WebHookProperties: map[string]*string{
	// 					"key11": to.Ptr("value11"),
	// 					"key12": to.Ptr("value12"),
	// 				},
	// 		}},
	// 		AutoMitigate: to.Ptr(false),
	// 		Criteria: &armmonitor.MetricAlertMultipleResourceMultipleMetricCriteria{
	// 			ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria),
	// 			AllOf: []armmonitor.MultiMetricCriteriaClassification{
	// 				&armmonitor.DynamicMetricCriteria{
	// 					Name: to.Ptr("High_CPU_80"),
	// 					CriterionType: to.Ptr(armmonitor.CriterionTypeDynamicThresholdCriterion),
	// 					Dimensions: []*armmonitor.MetricDimension{
	// 					},
	// 					MetricName: to.Ptr("Percentage CPU"),
	// 					MetricNamespace: to.Ptr("microsoft.compute/virtualmachines"),
	// 					TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
	// 					AlertSensitivity: to.Ptr(armmonitor.DynamicThresholdSensitivityMedium),
	// 					FailingPeriods: &armmonitor.DynamicThresholdFailingPeriods{
	// 						MinFailingPeriodsToAlert: to.Ptr[float32](4),
	// 						NumberOfEvaluationPeriods: to.Ptr[float32](4),
	// 					},
	// 					Operator: to.Ptr(armmonitor.DynamicThresholdOperatorGreaterOrLessThan),
	// 			}},
	// 		},
	// 		Enabled: to.Ptr(true),
	// 		EvaluationFrequency: to.Ptr("Pt1m"),
	// 		Scopes: []*string{
	// 			to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme")},
	// 			Severity: to.Ptr[int32](3),
	// 			WindowSize: to.Ptr("Pt15m"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/getWebTestMetricAlert.json
func ExampleMetricAlertsClient_Get_getAWebTestAlertRule() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricAlertsClient().Get(ctx, "rg-example", "webtest-name-example", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricAlertResource = armmonitor.MetricAlertResource{
	// 	Name: to.Ptr("webtest-name-example"),
	// 	Type: to.Ptr("Microsoft.Insights/metricAlerts"),
	// 	ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/metricalerts/webtest-name-example"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 		"hidden-link:/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/component-example": to.Ptr("Resource"),
	// 		"hidden-link:/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/webtest-name-example": to.Ptr("Resource"),
	// 	},
	// 	Properties: &armmonitor.MetricAlertProperties{
	// 		Description: to.Ptr("Automatically created alert rule for availability test \"webtest-name-example\""),
	// 		Actions: []*armmonitor.MetricAlertAction{
	// 		},
	// 		Criteria: &armmonitor.WebtestLocationAvailabilityCriteria{
	// 			ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria),
	// 			ComponentID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/component-example"),
	// 			FailedLocationCount: to.Ptr[float32](2),
	// 			WebTestID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/webtest-name-example"),
	// 		},
	// 		Enabled: to.Ptr(true),
	// 		EvaluationFrequency: to.Ptr("PT1M"),
	// 		Scopes: []*string{
	// 			to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/webtest-name-example"),
	// 			to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/component-example")},
	// 			Severity: to.Ptr[int32](4),
	// 			WindowSize: to.Ptr("PT15M"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/getMetricAlertMultipleResource.json
func ExampleMetricAlertsClient_Get_getAnAlertRuleForMultipleResources() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricAlertsClient().Get(ctx, "gigtest", "MetricAlertOnMultipleResources", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricAlertResource = armmonitor.MetricAlertResource{
	// 	Type: to.Ptr("Microsoft.Insights/metricAlerts"),
	// 	ID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/providers/microsoft.insights/metricalerts/MetricAlertOnMultipleResources"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 		"hidden-link:/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest": to.Ptr("Resource"),
	// 	},
	// 	Properties: &armmonitor.MetricAlertProperties{
	// 		Description: to.Ptr("This is the description of the rule1"),
	// 		Actions: []*armmonitor.MetricAlertAction{
	// 			{
	// 				ActionGroupID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
	// 				WebHookProperties: map[string]*string{
	// 					"key11": to.Ptr("value11"),
	// 					"key12": to.Ptr("value12"),
	// 				},
	// 		}},
	// 		AutoMitigate: to.Ptr(false),
	// 		Criteria: &armmonitor.MetricAlertMultipleResourceMultipleMetricCriteria{
	// 			ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria),
	// 			AllOf: []armmonitor.MultiMetricCriteriaClassification{
	// 				&armmonitor.MetricCriteria{
	// 					Name: to.Ptr("High_CPU_80"),
	// 					CriterionType: to.Ptr(armmonitor.CriterionTypeStaticThresholdCriterion),
	// 					Dimensions: []*armmonitor.MetricDimension{
	// 					},
	// 					MetricName: to.Ptr("Percentage CPU"),
	// 					MetricNamespace: to.Ptr("microsoft.compute/virtualmachines"),
	// 					TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
	// 					Operator: to.Ptr(armmonitor.OperatorGreaterThan),
	// 					Threshold: to.Ptr[float64](80.5),
	// 			}},
	// 		},
	// 		Enabled: to.Ptr(true),
	// 		EvaluationFrequency: to.Ptr("PT1M"),
	// 		Scopes: []*string{
	// 			to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme1"),
	// 			to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme2")},
	// 			Severity: to.Ptr[int32](3),
	// 			TargetResourceRegion: to.Ptr("southcentralus"),
	// 			TargetResourceType: to.Ptr("Microsoft.Compute/virtualMachines"),
	// 			WindowSize: to.Ptr("PT15M"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/getMetricAlertSingleResource.json
func ExampleMetricAlertsClient_Get_getAnAlertRuleForSingleResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricAlertsClient().Get(ctx, "gigtest", "chiricutin", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricAlertResource = armmonitor.MetricAlertResource{
	// 	Type: to.Ptr("Microsoft.Insights/metricAlerts"),
	// 	ID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/providers/microsoft.insights/metricalerts/chiricutin"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 		"hidden-link:/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest": to.Ptr("Resource"),
	// 	},
	// 	Properties: &armmonitor.MetricAlertProperties{
	// 		Description: to.Ptr("This is the description of the rule1"),
	// 		Actions: []*armmonitor.MetricAlertAction{
	// 			{
	// 				ActionGroupID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
	// 				WebHookProperties: map[string]*string{
	// 					"key11": to.Ptr("value11"),
	// 					"key12": to.Ptr("value12"),
	// 				},
	// 		}},
	// 		AutoMitigate: to.Ptr(false),
	// 		Criteria: &armmonitor.MetricAlertSingleResourceMultipleMetricCriteria{
	// 			ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria),
	// 			AllOf: []*armmonitor.MetricCriteria{
	// 				{
	// 					Name: to.Ptr("High_CPU_80"),
	// 					CriterionType: to.Ptr(armmonitor.CriterionTypeStaticThresholdCriterion),
	// 					Dimensions: []*armmonitor.MetricDimension{
	// 					},
	// 					MetricName: to.Ptr("\\Processor(_Total)\\% Processor Time"),
	// 					TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
	// 					Operator: to.Ptr(armmonitor.OperatorGreaterThan),
	// 					Threshold: to.Ptr[float64](80.5),
	// 			}},
	// 		},
	// 		Enabled: to.Ptr(true),
	// 		EvaluationFrequency: to.Ptr("Pt1m"),
	// 		Scopes: []*string{
	// 			to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme")},
	// 			Severity: to.Ptr[int32](3),
	// 			WindowSize: to.Ptr("Pt15m"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/getMetricAlertResourceGroup.json
func ExampleMetricAlertsClient_Get_getAnAlertRuleOnResourceGroupS() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricAlertsClient().Get(ctx, "gigtest1", "MetricAlertAtResourceGroupLevel", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricAlertResource = armmonitor.MetricAlertResource{
	// 	Type: to.Ptr("Microsoft.Insights/metricAlerts"),
	// 	ID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest1/providers/providers/microsoft.insights/metricalerts/MetricAlertAtResourceGroupLevel"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 		"hidden-link:/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest": to.Ptr("Resource"),
	// 	},
	// 	Properties: &armmonitor.MetricAlertProperties{
	// 		Description: to.Ptr("This is the description of the rule1"),
	// 		Actions: []*armmonitor.MetricAlertAction{
	// 			{
	// 				ActionGroupID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
	// 				WebHookProperties: map[string]*string{
	// 					"key11": to.Ptr("value11"),
	// 					"key12": to.Ptr("value12"),
	// 				},
	// 		}},
	// 		AutoMitigate: to.Ptr(false),
	// 		Criteria: &armmonitor.MetricAlertMultipleResourceMultipleMetricCriteria{
	// 			ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria),
	// 			AllOf: []armmonitor.MultiMetricCriteriaClassification{
	// 				&armmonitor.MetricCriteria{
	// 					Name: to.Ptr("High_CPU_80"),
	// 					CriterionType: to.Ptr(armmonitor.CriterionTypeStaticThresholdCriterion),
	// 					Dimensions: []*armmonitor.MetricDimension{
	// 					},
	// 					MetricName: to.Ptr("Percentage CPU"),
	// 					MetricNamespace: to.Ptr("microsoft.compute/virtualmachines"),
	// 					TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
	// 					Operator: to.Ptr(armmonitor.OperatorGreaterThan),
	// 					Threshold: to.Ptr[float64](80.5),
	// 			}},
	// 		},
	// 		Enabled: to.Ptr(true),
	// 		EvaluationFrequency: to.Ptr("PT1M"),
	// 		Scopes: []*string{
	// 			to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest1"),
	// 			to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest2")},
	// 			Severity: to.Ptr[int32](3),
	// 			TargetResourceRegion: to.Ptr("southcentralus"),
	// 			TargetResourceType: to.Ptr("Microsoft.Compute/virtualMachines"),
	// 			WindowSize: to.Ptr("PT15M"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/getMetricAlertSubscription.json
func ExampleMetricAlertsClient_Get_getAnAlertRuleOnSubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricAlertsClient().Get(ctx, "gigtest", "MetricAlertAtSubscriptionLevel", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricAlertResource = armmonitor.MetricAlertResource{
	// 	Type: to.Ptr("Microsoft.Insights/metricAlerts"),
	// 	ID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/providers/microsoft.insights/metricalerts/MetricAlertAtSubscriptionLevel"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 		"hidden-link:/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest": to.Ptr("Resource"),
	// 	},
	// 	Properties: &armmonitor.MetricAlertProperties{
	// 		Description: to.Ptr("This is the description of the rule1"),
	// 		Actions: []*armmonitor.MetricAlertAction{
	// 			{
	// 				ActionGroupID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
	// 				WebHookProperties: map[string]*string{
	// 					"key11": to.Ptr("value11"),
	// 					"key12": to.Ptr("value12"),
	// 				},
	// 		}},
	// 		AutoMitigate: to.Ptr(false),
	// 		Criteria: &armmonitor.MetricAlertMultipleResourceMultipleMetricCriteria{
	// 			ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria),
	// 			AllOf: []armmonitor.MultiMetricCriteriaClassification{
	// 				&armmonitor.MetricCriteria{
	// 					Name: to.Ptr("High_CPU_80"),
	// 					CriterionType: to.Ptr(armmonitor.CriterionTypeStaticThresholdCriterion),
	// 					Dimensions: []*armmonitor.MetricDimension{
	// 					},
	// 					MetricName: to.Ptr("Percentage CPU"),
	// 					MetricNamespace: to.Ptr("microsoft.compute/virtualmachines"),
	// 					TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
	// 					Operator: to.Ptr(armmonitor.OperatorGreaterThan),
	// 					Threshold: to.Ptr[float64](80.5),
	// 			}},
	// 		},
	// 		Enabled: to.Ptr(true),
	// 		EvaluationFrequency: to.Ptr("PT1M"),
	// 		Scopes: []*string{
	// 			to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7")},
	// 			Severity: to.Ptr[int32](3),
	// 			TargetResourceRegion: to.Ptr("southcentralus"),
	// 			TargetResourceType: to.Ptr("Microsoft.Compute/virtualMachines"),
	// 			WindowSize: to.Ptr("PT15M"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/createOrUpdateDynamicMetricAlertMultipleResource.json
func ExampleMetricAlertsClient_CreateOrUpdate_createOrUpdateADynamicAlertRuleForMultipleResources() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricAlertsClient().CreateOrUpdate(ctx, "gigtest", "MetricAlertOnMultipleResources", armmonitor.MetricAlertResource{
		Location: to.Ptr("global"),
		Tags:     map[string]*string{},
		Properties: &armmonitor.MetricAlertProperties{
			Description: to.Ptr("This is the description of the rule1"),
			Actions: []*armmonitor.MetricAlertAction{
				{
					ActionGroupID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
					WebHookProperties: map[string]*string{
						"key11": to.Ptr("value11"),
						"key12": to.Ptr("value12"),
					},
				}},
			AutoMitigate: to.Ptr(true),
			Criteria: &armmonitor.MetricAlertMultipleResourceMultipleMetricCriteria{
				ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria),
				AllOf: []armmonitor.MultiMetricCriteriaClassification{
					&armmonitor.DynamicMetricCriteria{
						Name:             to.Ptr("High_CPU_80"),
						CriterionType:    to.Ptr(armmonitor.CriterionTypeDynamicThresholdCriterion),
						Dimensions:       []*armmonitor.MetricDimension{},
						MetricName:       to.Ptr("Percentage CPU"),
						MetricNamespace:  to.Ptr("microsoft.compute/virtualmachines"),
						TimeAggregation:  to.Ptr(armmonitor.AggregationTypeEnumAverage),
						AlertSensitivity: to.Ptr(armmonitor.DynamicThresholdSensitivityMedium),
						FailingPeriods: &armmonitor.DynamicThresholdFailingPeriods{
							MinFailingPeriodsToAlert:  to.Ptr[float32](4),
							NumberOfEvaluationPeriods: to.Ptr[float32](4),
						},
						Operator: to.Ptr(armmonitor.DynamicThresholdOperatorGreaterOrLessThan),
					}},
			},
			Enabled:             to.Ptr(true),
			EvaluationFrequency: to.Ptr("PT1M"),
			Scopes: []*string{
				to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme1"),
				to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme2")},
			Severity:             to.Ptr[int32](3),
			TargetResourceRegion: to.Ptr("southcentralus"),
			TargetResourceType:   to.Ptr("Microsoft.Compute/virtualMachines"),
			WindowSize:           to.Ptr("PT15M"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricAlertResource = armmonitor.MetricAlertResource{
	// 	Type: to.Ptr("Microsoft.Insights/metricAlerts"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/providers/microsoft.insights/metricalerts/MetricAlertOnMultipleResources"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 		"hidden-link:/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest": to.Ptr("Resource"),
	// 	},
	// 	Properties: &armmonitor.MetricAlertProperties{
	// 		Description: to.Ptr("This is the description of the rule1"),
	// 		Actions: []*armmonitor.MetricAlertAction{
	// 			{
	// 				ActionGroupID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
	// 				WebHookProperties: map[string]*string{
	// 					"key11": to.Ptr("value11"),
	// 					"key12": to.Ptr("value12"),
	// 				},
	// 		}},
	// 		AutoMitigate: to.Ptr(true),
	// 		Criteria: &armmonitor.MetricAlertMultipleResourceMultipleMetricCriteria{
	// 			ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria),
	// 			AllOf: []armmonitor.MultiMetricCriteriaClassification{
	// 				&armmonitor.DynamicMetricCriteria{
	// 					Name: to.Ptr("High_CPU_80"),
	// 					CriterionType: to.Ptr(armmonitor.CriterionTypeDynamicThresholdCriterion),
	// 					Dimensions: []*armmonitor.MetricDimension{
	// 					},
	// 					MetricName: to.Ptr("Percentage CPU"),
	// 					MetricNamespace: to.Ptr("microsoft.compute/virtualmachines"),
	// 					TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
	// 					AlertSensitivity: to.Ptr(armmonitor.DynamicThresholdSensitivityMedium),
	// 					FailingPeriods: &armmonitor.DynamicThresholdFailingPeriods{
	// 						MinFailingPeriodsToAlert: to.Ptr[float32](4),
	// 						NumberOfEvaluationPeriods: to.Ptr[float32](4),
	// 					},
	// 					Operator: to.Ptr(armmonitor.DynamicThresholdOperatorGreaterOrLessThan),
	// 			}},
	// 		},
	// 		Enabled: to.Ptr(true),
	// 		EvaluationFrequency: to.Ptr("PT1M"),
	// 		Scopes: []*string{
	// 			to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme1"),
	// 			to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme2")},
	// 			Severity: to.Ptr[int32](3),
	// 			TargetResourceRegion: to.Ptr("southcentralus"),
	// 			TargetResourceType: to.Ptr("Microsoft.Compute/virtualMachines"),
	// 			WindowSize: to.Ptr("PT15M"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/createOrUpdateDynamicMetricAlertSingleResource.json
func ExampleMetricAlertsClient_CreateOrUpdate_createOrUpdateADynamicAlertRuleForSingleResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricAlertsClient().CreateOrUpdate(ctx, "gigtest", "chiricutin", armmonitor.MetricAlertResource{
		Location: to.Ptr("global"),
		Tags:     map[string]*string{},
		Properties: &armmonitor.MetricAlertProperties{
			Description: to.Ptr("This is the description of the rule1"),
			Actions: []*armmonitor.MetricAlertAction{
				{
					ActionGroupID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
					WebHookProperties: map[string]*string{
						"key11": to.Ptr("value11"),
						"key12": to.Ptr("value12"),
					},
				}},
			AutoMitigate: to.Ptr(true),
			Criteria: &armmonitor.MetricAlertMultipleResourceMultipleMetricCriteria{
				ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria),
				AllOf: []armmonitor.MultiMetricCriteriaClassification{
					&armmonitor.DynamicMetricCriteria{
						Name:             to.Ptr("High_CPU_80"),
						CriterionType:    to.Ptr(armmonitor.CriterionTypeDynamicThresholdCriterion),
						Dimensions:       []*armmonitor.MetricDimension{},
						MetricName:       to.Ptr("Percentage CPU"),
						MetricNamespace:  to.Ptr("microsoft.compute/virtualmachines"),
						TimeAggregation:  to.Ptr(armmonitor.AggregationTypeEnumAverage),
						AlertSensitivity: to.Ptr(armmonitor.DynamicThresholdSensitivityMedium),
						FailingPeriods: &armmonitor.DynamicThresholdFailingPeriods{
							MinFailingPeriodsToAlert:  to.Ptr[float32](4),
							NumberOfEvaluationPeriods: to.Ptr[float32](4),
						},
						IgnoreDataBefore: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-04T21:00:00.000Z"); return t }()),
						Operator:         to.Ptr(armmonitor.DynamicThresholdOperatorGreaterOrLessThan),
					}},
			},
			Enabled:             to.Ptr(true),
			EvaluationFrequency: to.Ptr("PT1M"),
			Scopes: []*string{
				to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme")},
			Severity:   to.Ptr[int32](3),
			WindowSize: to.Ptr("PT15M"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricAlertResource = armmonitor.MetricAlertResource{
	// 	Type: to.Ptr("Microsoft.Insights/metricAlerts"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/providers/microsoft.insights/metricalerts/chiricutin"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 		"hidden-link:/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest": to.Ptr("Resource"),
	// 	},
	// 	Properties: &armmonitor.MetricAlertProperties{
	// 		Description: to.Ptr("This is the description of the rule1"),
	// 		Actions: []*armmonitor.MetricAlertAction{
	// 			{
	// 				ActionGroupID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
	// 				WebHookProperties: map[string]*string{
	// 					"key11": to.Ptr("value11"),
	// 					"key12": to.Ptr("value12"),
	// 				},
	// 		}},
	// 		AutoMitigate: to.Ptr(true),
	// 		Criteria: &armmonitor.MetricAlertMultipleResourceMultipleMetricCriteria{
	// 			ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria),
	// 			AllOf: []armmonitor.MultiMetricCriteriaClassification{
	// 				&armmonitor.DynamicMetricCriteria{
	// 					Name: to.Ptr("High_CPU_80"),
	// 					CriterionType: to.Ptr(armmonitor.CriterionTypeDynamicThresholdCriterion),
	// 					Dimensions: []*armmonitor.MetricDimension{
	// 					},
	// 					MetricName: to.Ptr("Percentage CPU"),
	// 					MetricNamespace: to.Ptr("microsoft.compute/virtualmachines"),
	// 					TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
	// 					AlertSensitivity: to.Ptr(armmonitor.DynamicThresholdSensitivityMedium),
	// 					FailingPeriods: &armmonitor.DynamicThresholdFailingPeriods{
	// 						MinFailingPeriodsToAlert: to.Ptr[float32](4),
	// 						NumberOfEvaluationPeriods: to.Ptr[float32](4),
	// 					},
	// 					IgnoreDataBefore: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-04T21:00:00.000Z"); return t}()),
	// 					Operator: to.Ptr(armmonitor.DynamicThresholdOperatorGreaterOrLessThan),
	// 			}},
	// 		},
	// 		Enabled: to.Ptr(true),
	// 		EvaluationFrequency: to.Ptr("PT1M"),
	// 		Scopes: []*string{
	// 			to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme")},
	// 			Severity: to.Ptr[int32](3),
	// 			TargetResourceRegion: to.Ptr("southcentralus"),
	// 			TargetResourceType: to.Ptr("Microsoft.Compute/virtualMachines"),
	// 			WindowSize: to.Ptr("PT15M"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/createOrUpdateWebTestMetricAlert.json
func ExampleMetricAlertsClient_CreateOrUpdate_createOrUpdateAWebTestAlertRule() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricAlertsClient().CreateOrUpdate(ctx, "rg-example", "webtest-name-example", armmonitor.MetricAlertResource{
		Location: to.Ptr("global"),
		Tags: map[string]*string{
			"hidden-link:/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example": to.Ptr("Resource"),
			"hidden-link:/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example":      to.Ptr("Resource"),
		},
		Properties: &armmonitor.MetricAlertProperties{
			Description: to.Ptr("Automatically created alert rule for availability test \"component-example\" a"),
			Actions:     []*armmonitor.MetricAlertAction{},
			Criteria: &armmonitor.WebtestLocationAvailabilityCriteria{
				ODataType:           to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria),
				ComponentID:         to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example"),
				FailedLocationCount: to.Ptr[float32](2),
				WebTestID:           to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example"),
			},
			Enabled:             to.Ptr(true),
			EvaluationFrequency: to.Ptr("PT1M"),
			Scopes: []*string{
				to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example"),
				to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example")},
			Severity:   to.Ptr[int32](4),
			WindowSize: to.Ptr("PT15M"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricAlertResource = armmonitor.MetricAlertResource{
	// 	Name: to.Ptr("webtest-name-example"),
	// 	Type: to.Ptr("Microsoft.Insights/metricAlerts"),
	// 	ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/metricalerts/webtest-name-example"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 		"hidden-link:/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/component-example": to.Ptr("Resource"),
	// 		"hidden-link:/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/webtest-name-example": to.Ptr("Resource"),
	// 	},
	// 	Properties: &armmonitor.MetricAlertProperties{
	// 		Description: to.Ptr("Automatically created alert rule for availability test \"webtest-name-example\" a"),
	// 		Actions: []*armmonitor.MetricAlertAction{
	// 		},
	// 		Criteria: &armmonitor.WebtestLocationAvailabilityCriteria{
	// 			ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria),
	// 			ComponentID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/component-example"),
	// 			FailedLocationCount: to.Ptr[float32](2),
	// 			WebTestID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/webtest-name-example"),
	// 		},
	// 		Enabled: to.Ptr(true),
	// 		EvaluationFrequency: to.Ptr("PT1M"),
	// 		Scopes: []*string{
	// 			to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/webtest-name-example"),
	// 			to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/component-example")},
	// 			Severity: to.Ptr[int32](4),
	// 			WindowSize: to.Ptr("PT15M"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/createOrUpdateMetricAlertMultipleResource.json
func ExampleMetricAlertsClient_CreateOrUpdate_createOrUpdateAnAlertRuleForMultipleResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricAlertsClient().CreateOrUpdate(ctx, "gigtest", "MetricAlertOnMultipleResources", armmonitor.MetricAlertResource{
		Location: to.Ptr("global"),
		Tags:     map[string]*string{},
		Properties: &armmonitor.MetricAlertProperties{
			Description: to.Ptr("This is the description of the rule1"),
			Actions: []*armmonitor.MetricAlertAction{
				{
					ActionGroupID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
					WebHookProperties: map[string]*string{
						"key11": to.Ptr("value11"),
						"key12": to.Ptr("value12"),
					},
				}},
			AutoMitigate: to.Ptr(true),
			Criteria: &armmonitor.MetricAlertMultipleResourceMultipleMetricCriteria{
				ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria),
				AllOf: []armmonitor.MultiMetricCriteriaClassification{
					&armmonitor.MetricCriteria{
						Name:            to.Ptr("High_CPU_80"),
						CriterionType:   to.Ptr(armmonitor.CriterionTypeStaticThresholdCriterion),
						Dimensions:      []*armmonitor.MetricDimension{},
						MetricName:      to.Ptr("Percentage CPU"),
						MetricNamespace: to.Ptr("microsoft.compute/virtualmachines"),
						TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
						Operator:        to.Ptr(armmonitor.OperatorGreaterThan),
						Threshold:       to.Ptr[float64](80.5),
					}},
			},
			Enabled:             to.Ptr(true),
			EvaluationFrequency: to.Ptr("PT1M"),
			Scopes: []*string{
				to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme1"),
				to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme2")},
			Severity:             to.Ptr[int32](3),
			TargetResourceRegion: to.Ptr("southcentralus"),
			TargetResourceType:   to.Ptr("Microsoft.Compute/virtualMachines"),
			WindowSize:           to.Ptr("PT15M"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricAlertResource = armmonitor.MetricAlertResource{
	// 	Type: to.Ptr("Microsoft.Insights/metricAlerts"),
	// 	ID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/providers/microsoft.insights/metricalerts/MetricAlertOnMultipleResources"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 		"hidden-link:/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest": to.Ptr("Resource"),
	// 	},
	// 	Properties: &armmonitor.MetricAlertProperties{
	// 		Description: to.Ptr("This is the description of the rule1"),
	// 		Actions: []*armmonitor.MetricAlertAction{
	// 			{
	// 				ActionGroupID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
	// 				WebHookProperties: map[string]*string{
	// 					"key11": to.Ptr("value11"),
	// 					"key12": to.Ptr("value12"),
	// 				},
	// 		}},
	// 		AutoMitigate: to.Ptr(true),
	// 		Criteria: &armmonitor.MetricAlertMultipleResourceMultipleMetricCriteria{
	// 			ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria),
	// 			AllOf: []armmonitor.MultiMetricCriteriaClassification{
	// 				&armmonitor.MetricCriteria{
	// 					Name: to.Ptr("High_CPU_80"),
	// 					CriterionType: to.Ptr(armmonitor.CriterionTypeStaticThresholdCriterion),
	// 					Dimensions: []*armmonitor.MetricDimension{
	// 					},
	// 					MetricName: to.Ptr("Percentage CPU"),
	// 					MetricNamespace: to.Ptr("microsoft.compute/virtualmachines"),
	// 					TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
	// 					Operator: to.Ptr(armmonitor.OperatorGreaterThan),
	// 					Threshold: to.Ptr[float64](80.5),
	// 			}},
	// 		},
	// 		Enabled: to.Ptr(true),
	// 		EvaluationFrequency: to.Ptr("PT1M"),
	// 		Scopes: []*string{
	// 			to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme1"),
	// 			to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme2")},
	// 			Severity: to.Ptr[int32](3),
	// 			TargetResourceRegion: to.Ptr("southcentralus"),
	// 			TargetResourceType: to.Ptr("Microsoft.Compute/virtualMachines"),
	// 			WindowSize: to.Ptr("PT15M"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/createOrUpdateMetricAlertSingleResource.json
func ExampleMetricAlertsClient_CreateOrUpdate_createOrUpdateAnAlertRuleForSingleResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricAlertsClient().CreateOrUpdate(ctx, "gigtest", "chiricutin", armmonitor.MetricAlertResource{
		Location: to.Ptr("global"),
		Tags:     map[string]*string{},
		Properties: &armmonitor.MetricAlertProperties{
			Description: to.Ptr("This is the description of the rule1"),
			Actions: []*armmonitor.MetricAlertAction{
				{
					ActionGroupID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
					WebHookProperties: map[string]*string{
						"key11": to.Ptr("value11"),
						"key12": to.Ptr("value12"),
					},
				}},
			AutoMitigate: to.Ptr(true),
			Criteria: &armmonitor.MetricAlertSingleResourceMultipleMetricCriteria{
				ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria),
				AllOf: []*armmonitor.MetricCriteria{
					{
						Name:            to.Ptr("High_CPU_80"),
						CriterionType:   to.Ptr(armmonitor.CriterionTypeStaticThresholdCriterion),
						Dimensions:      []*armmonitor.MetricDimension{},
						MetricName:      to.Ptr("\\Processor(_Total)\\% Processor Time"),
						TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
						Operator:        to.Ptr(armmonitor.OperatorGreaterThan),
						Threshold:       to.Ptr[float64](80.5),
					}},
			},
			Enabled:             to.Ptr(true),
			EvaluationFrequency: to.Ptr("Pt1m"),
			Scopes: []*string{
				to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme")},
			Severity:   to.Ptr[int32](3),
			WindowSize: to.Ptr("Pt15m"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricAlertResource = armmonitor.MetricAlertResource{
	// 	Type: to.Ptr("Microsoft.Insights/metricAlerts"),
	// 	ID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/providers/microsoft.insights/metricalerts/chiricutin"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 		"hidden-link:/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest": to.Ptr("Resource"),
	// 	},
	// 	Properties: &armmonitor.MetricAlertProperties{
	// 		Description: to.Ptr("This is the description of the rule1"),
	// 		Actions: []*armmonitor.MetricAlertAction{
	// 			{
	// 				ActionGroupID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
	// 				WebHookProperties: map[string]*string{
	// 					"key11": to.Ptr("value11"),
	// 					"key12": to.Ptr("value12"),
	// 				},
	// 		}},
	// 		AutoMitigate: to.Ptr(true),
	// 		Criteria: &armmonitor.MetricAlertSingleResourceMultipleMetricCriteria{
	// 			ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria),
	// 			AllOf: []*armmonitor.MetricCriteria{
	// 				{
	// 					Name: to.Ptr("High_CPU_80"),
	// 					CriterionType: to.Ptr(armmonitor.CriterionTypeStaticThresholdCriterion),
	// 					Dimensions: []*armmonitor.MetricDimension{
	// 					},
	// 					MetricName: to.Ptr("\\Processor(_Total)\\% Processor Time"),
	// 					TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
	// 					Operator: to.Ptr(armmonitor.OperatorGreaterThan),
	// 					Threshold: to.Ptr[float64](80.5),
	// 			}},
	// 		},
	// 		Enabled: to.Ptr(true),
	// 		EvaluationFrequency: to.Ptr("Pt1m"),
	// 		Scopes: []*string{
	// 			to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme")},
	// 			Severity: to.Ptr[int32](3),
	// 			WindowSize: to.Ptr("Pt15m"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/createOrUpdateMetricAlertResourceGroup.json
func ExampleMetricAlertsClient_CreateOrUpdate_createOrUpdateAnAlertRuleOnResourceGroupS() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricAlertsClient().CreateOrUpdate(ctx, "gigtest1", "MetricAlertAtResourceGroupLevel", armmonitor.MetricAlertResource{
		Location: to.Ptr("global"),
		Tags:     map[string]*string{},
		Properties: &armmonitor.MetricAlertProperties{
			Description: to.Ptr("This is the description of the rule1"),
			Actions: []*armmonitor.MetricAlertAction{
				{
					ActionGroupID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
					WebHookProperties: map[string]*string{
						"key11": to.Ptr("value11"),
						"key12": to.Ptr("value12"),
					},
				}},
			AutoMitigate: to.Ptr(true),
			Criteria: &armmonitor.MetricAlertMultipleResourceMultipleMetricCriteria{
				ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria),
				AllOf: []armmonitor.MultiMetricCriteriaClassification{
					&armmonitor.MetricCriteria{
						Name:            to.Ptr("High_CPU_80"),
						CriterionType:   to.Ptr(armmonitor.CriterionTypeStaticThresholdCriterion),
						Dimensions:      []*armmonitor.MetricDimension{},
						MetricName:      to.Ptr("Percentage CPU"),
						MetricNamespace: to.Ptr("microsoft.compute/virtualmachines"),
						TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
						Operator:        to.Ptr(armmonitor.OperatorGreaterThan),
						Threshold:       to.Ptr[float64](80.5),
					}},
			},
			Enabled:             to.Ptr(true),
			EvaluationFrequency: to.Ptr("PT1M"),
			Scopes: []*string{
				to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest1"),
				to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest2")},
			Severity:             to.Ptr[int32](3),
			TargetResourceRegion: to.Ptr("southcentralus"),
			TargetResourceType:   to.Ptr("Microsoft.Compute/virtualMachines"),
			WindowSize:           to.Ptr("PT15M"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricAlertResource = armmonitor.MetricAlertResource{
	// 	Type: to.Ptr("Microsoft.Insights/metricAlerts"),
	// 	ID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest1/providers/providers/microsoft.insights/metricalerts/MetricAlertAtResourceGroupLevel"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 		"hidden-link:/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest": to.Ptr("Resource"),
	// 	},
	// 	Properties: &armmonitor.MetricAlertProperties{
	// 		Description: to.Ptr("This is the description of the rule1"),
	// 		Actions: []*armmonitor.MetricAlertAction{
	// 			{
	// 				ActionGroupID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
	// 				WebHookProperties: map[string]*string{
	// 					"key11": to.Ptr("value11"),
	// 					"key12": to.Ptr("value12"),
	// 				},
	// 		}},
	// 		AutoMitigate: to.Ptr(true),
	// 		Criteria: &armmonitor.MetricAlertMultipleResourceMultipleMetricCriteria{
	// 			ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria),
	// 			AllOf: []armmonitor.MultiMetricCriteriaClassification{
	// 				&armmonitor.MetricCriteria{
	// 					Name: to.Ptr("High_CPU_80"),
	// 					CriterionType: to.Ptr(armmonitor.CriterionTypeStaticThresholdCriterion),
	// 					Dimensions: []*armmonitor.MetricDimension{
	// 					},
	// 					MetricName: to.Ptr("Percentage CPU"),
	// 					MetricNamespace: to.Ptr("microsoft.compute/virtualmachines"),
	// 					TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
	// 					Operator: to.Ptr(armmonitor.OperatorGreaterThan),
	// 					Threshold: to.Ptr[float64](80.5),
	// 			}},
	// 		},
	// 		Enabled: to.Ptr(true),
	// 		EvaluationFrequency: to.Ptr("PT1M"),
	// 		Scopes: []*string{
	// 			to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest1"),
	// 			to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest2")},
	// 			Severity: to.Ptr[int32](3),
	// 			TargetResourceRegion: to.Ptr("southcentralus"),
	// 			TargetResourceType: to.Ptr("Microsoft.Compute/virtualMachines"),
	// 			WindowSize: to.Ptr("PT15M"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/createOrUpdateMetricAlertSubscription.json
func ExampleMetricAlertsClient_CreateOrUpdate_createOrUpdateAnAlertRuleOnSubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricAlertsClient().CreateOrUpdate(ctx, "gigtest", "MetricAlertAtSubscriptionLevel", armmonitor.MetricAlertResource{
		Location: to.Ptr("global"),
		Tags:     map[string]*string{},
		Properties: &armmonitor.MetricAlertProperties{
			Description: to.Ptr("This is the description of the rule1"),
			Actions: []*armmonitor.MetricAlertAction{
				{
					ActionGroupID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
					WebHookProperties: map[string]*string{
						"key11": to.Ptr("value11"),
						"key12": to.Ptr("value12"),
					},
				}},
			AutoMitigate: to.Ptr(true),
			Criteria: &armmonitor.MetricAlertMultipleResourceMultipleMetricCriteria{
				ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria),
				AllOf: []armmonitor.MultiMetricCriteriaClassification{
					&armmonitor.MetricCriteria{
						Name:            to.Ptr("High_CPU_80"),
						CriterionType:   to.Ptr(armmonitor.CriterionTypeStaticThresholdCriterion),
						Dimensions:      []*armmonitor.MetricDimension{},
						MetricName:      to.Ptr("Percentage CPU"),
						MetricNamespace: to.Ptr("microsoft.compute/virtualmachines"),
						TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
						Operator:        to.Ptr(armmonitor.OperatorGreaterThan),
						Threshold:       to.Ptr[float64](80.5),
					}},
			},
			Enabled:             to.Ptr(true),
			EvaluationFrequency: to.Ptr("PT1M"),
			Scopes: []*string{
				to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7")},
			Severity:             to.Ptr[int32](3),
			TargetResourceRegion: to.Ptr("southcentralus"),
			TargetResourceType:   to.Ptr("Microsoft.Compute/virtualMachines"),
			WindowSize:           to.Ptr("PT15M"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricAlertResource = armmonitor.MetricAlertResource{
	// 	Type: to.Ptr("Microsoft.Insights/metricAlerts"),
	// 	ID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/providers/microsoft.insights/metricalerts/MetricAlertAtSubscriptionLevel"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 		"hidden-link:/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest": to.Ptr("Resource"),
	// 	},
	// 	Properties: &armmonitor.MetricAlertProperties{
	// 		Description: to.Ptr("This is the description of the rule1"),
	// 		Actions: []*armmonitor.MetricAlertAction{
	// 			{
	// 				ActionGroupID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
	// 				WebHookProperties: map[string]*string{
	// 					"key11": to.Ptr("value11"),
	// 					"key12": to.Ptr("value12"),
	// 				},
	// 		}},
	// 		AutoMitigate: to.Ptr(true),
	// 		Criteria: &armmonitor.MetricAlertMultipleResourceMultipleMetricCriteria{
	// 			ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria),
	// 			AllOf: []armmonitor.MultiMetricCriteriaClassification{
	// 				&armmonitor.MetricCriteria{
	// 					Name: to.Ptr("High_CPU_80"),
	// 					CriterionType: to.Ptr(armmonitor.CriterionTypeStaticThresholdCriterion),
	// 					Dimensions: []*armmonitor.MetricDimension{
	// 					},
	// 					MetricName: to.Ptr("Percentage CPU"),
	// 					MetricNamespace: to.Ptr("microsoft.compute/virtualmachines"),
	// 					TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
	// 					Operator: to.Ptr(armmonitor.OperatorGreaterThan),
	// 					Threshold: to.Ptr[float64](80.5),
	// 			}},
	// 		},
	// 		Enabled: to.Ptr(true),
	// 		EvaluationFrequency: to.Ptr("PT1M"),
	// 		Scopes: []*string{
	// 			to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7")},
	// 			Severity: to.Ptr[int32](3),
	// 			TargetResourceRegion: to.Ptr("southcentralus"),
	// 			TargetResourceType: to.Ptr("Microsoft.Compute/virtualMachines"),
	// 			WindowSize: to.Ptr("PT15M"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/createOrUpdateMetricAlertWithDimensions.json
func ExampleMetricAlertsClient_CreateOrUpdate_createOrUpdateAnAlertRulesWithDimensions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricAlertsClient().CreateOrUpdate(ctx, "gigtest", "MetricAlertOnMultipleDimensions", armmonitor.MetricAlertResource{
		Location: to.Ptr("global"),
		Tags:     map[string]*string{},
		Properties: &armmonitor.MetricAlertProperties{
			Description: to.Ptr("This is the description of the rule1"),
			Actions: []*armmonitor.MetricAlertAction{
				{
					ActionGroupID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
					WebHookProperties: map[string]*string{
						"key11": to.Ptr("value11"),
						"key12": to.Ptr("value12"),
					},
				}},
			AutoMitigate: to.Ptr(true),
			Criteria: &armmonitor.MetricAlertMultipleResourceMultipleMetricCriteria{
				ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria),
				AllOf: []armmonitor.MultiMetricCriteriaClassification{
					&armmonitor.MetricCriteria{
						Name:          to.Ptr("Metric1"),
						CriterionType: to.Ptr(armmonitor.CriterionTypeStaticThresholdCriterion),
						Dimensions: []*armmonitor.MetricDimension{
							{
								Name:     to.Ptr("ActivityName"),
								Operator: to.Ptr("Include"),
								Values: []*string{
									to.Ptr("*")},
							},
							{
								Name:     to.Ptr("StatusCode"),
								Operator: to.Ptr("Include"),
								Values: []*string{
									to.Ptr("200")},
							}},
						MetricName:      to.Ptr("Availability"),
						MetricNamespace: to.Ptr("Microsoft.KeyVault/vaults"),
						TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
						Operator:        to.Ptr(armmonitor.OperatorGreaterThan),
						Threshold:       to.Ptr[float64](55),
					}},
			},
			Enabled:             to.Ptr(true),
			EvaluationFrequency: to.Ptr("PT1H"),
			Scopes: []*string{
				to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.KeyVault/vaults/keyVaultResource")},
			Severity:   to.Ptr[int32](3),
			WindowSize: to.Ptr("P1D"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricAlertResource = armmonitor.MetricAlertResource{
	// 	Type: to.Ptr("Microsoft.Insights/metricAlerts"),
	// 	ID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/providers/microsoft.insights/metricalerts/MetricAlertWithDimensions"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 		"hidden-link:/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest": to.Ptr("Resource"),
	// 	},
	// 	Properties: &armmonitor.MetricAlertProperties{
	// 		Description: to.Ptr("This is the description of the rule1"),
	// 		Actions: []*armmonitor.MetricAlertAction{
	// 			{
	// 				ActionGroupID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
	// 				WebHookProperties: map[string]*string{
	// 					"key11": to.Ptr("value11"),
	// 					"key12": to.Ptr("value12"),
	// 				},
	// 		}},
	// 		AutoMitigate: to.Ptr(true),
	// 		Criteria: &armmonitor.MetricAlertMultipleResourceMultipleMetricCriteria{
	// 			ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria),
	// 			AllOf: []armmonitor.MultiMetricCriteriaClassification{
	// 				&armmonitor.MetricCriteria{
	// 					Name: to.Ptr("Metric1"),
	// 					CriterionType: to.Ptr(armmonitor.CriterionTypeStaticThresholdCriterion),
	// 					Dimensions: []*armmonitor.MetricDimension{
	// 						{
	// 							Name: to.Ptr("ActivityName"),
	// 							Operator: to.Ptr("Include"),
	// 							Values: []*string{
	// 								to.Ptr("*")},
	// 							},
	// 							{
	// 								Name: to.Ptr("StatusCode"),
	// 								Operator: to.Ptr("Include"),
	// 								Values: []*string{
	// 									to.Ptr("200")},
	// 							}},
	// 							MetricName: to.Ptr("Availability"),
	// 							MetricNamespace: to.Ptr("Microsoft.KeyVault/vaults"),
	// 							TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
	// 							Operator: to.Ptr(armmonitor.OperatorGreaterThan),
	// 							Threshold: to.Ptr[float64](55),
	// 					}},
	// 				},
	// 				Enabled: to.Ptr(true),
	// 				EvaluationFrequency: to.Ptr("PT1H"),
	// 				Scopes: []*string{
	// 					to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.KeyVault/vaults/keyVaultResource")},
	// 					Severity: to.Ptr[int32](3),
	// 					TargetResourceRegion: to.Ptr("southcentralus"),
	// 					TargetResourceType: to.Ptr("Microsoft.KeyVault/vaults"),
	// 					WindowSize: to.Ptr("P1D"),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/UpdateMetricAlert.json
func ExampleMetricAlertsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMetricAlertsClient().Update(ctx, "gigtest", "chiricutin", armmonitor.MetricAlertResourcePatch{
		Properties: &armmonitor.MetricAlertPropertiesPatch{
			Description: to.Ptr("This is the description of the rule1"),
			Actions: []*armmonitor.MetricAlertAction{
				{
					ActionGroupID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
					WebHookProperties: map[string]*string{
						"key11": to.Ptr("value11"),
						"key12": to.Ptr("value12"),
					},
				}},
			AutoMitigate: to.Ptr(true),
			Criteria: &armmonitor.MetricAlertSingleResourceMultipleMetricCriteria{
				ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria),
				AllOf: []*armmonitor.MetricCriteria{
					{
						Name:            to.Ptr("High_CPU_80"),
						CriterionType:   to.Ptr(armmonitor.CriterionTypeStaticThresholdCriterion),
						Dimensions:      []*armmonitor.MetricDimension{},
						MetricName:      to.Ptr("\\Processor(_Total)\\% Processor Time"),
						TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
						Operator:        to.Ptr(armmonitor.OperatorGreaterThan),
						Threshold:       to.Ptr[float64](80.5),
					}},
			},
			Enabled:             to.Ptr(true),
			EvaluationFrequency: to.Ptr("Pt1m"),
			Scopes: []*string{
				to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme")},
			Severity:   to.Ptr[int32](3),
			WindowSize: to.Ptr("Pt15m"),
		},
		Tags: map[string]*string{},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricAlertResource = armmonitor.MetricAlertResource{
	// 	Type: to.Ptr("Microsoft.Insights/metricAlerts"),
	// 	ID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/providers/microsoft.insights/metricalerts/chiricutin"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 		"hidden-link:/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest": to.Ptr("Resource"),
	// 	},
	// 	Properties: &armmonitor.MetricAlertProperties{
	// 		Description: to.Ptr("This is the description of the rule1"),
	// 		Actions: []*armmonitor.MetricAlertAction{
	// 			{
	// 				ActionGroupID: to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
	// 				WebHookProperties: map[string]*string{
	// 					"key11": to.Ptr("value11"),
	// 					"key12": to.Ptr("value12"),
	// 				},
	// 		}},
	// 		AutoMitigate: to.Ptr(true),
	// 		Criteria: &armmonitor.MetricAlertSingleResourceMultipleMetricCriteria{
	// 			ODataType: to.Ptr(armmonitor.OdatatypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria),
	// 			AllOf: []*armmonitor.MetricCriteria{
	// 				{
	// 					Name: to.Ptr("High_CPU_80"),
	// 					CriterionType: to.Ptr(armmonitor.CriterionTypeStaticThresholdCriterion),
	// 					Dimensions: []*armmonitor.MetricDimension{
	// 					},
	// 					MetricName: to.Ptr("\\Processor(_Total)\\% Processor Time"),
	// 					TimeAggregation: to.Ptr(armmonitor.AggregationTypeEnumAverage),
	// 					Operator: to.Ptr(armmonitor.OperatorGreaterThan),
	// 					Threshold: to.Ptr[float64](80.5),
	// 			}},
	// 		},
	// 		Enabled: to.Ptr(true),
	// 		EvaluationFrequency: to.Ptr("Pt1m"),
	// 		Scopes: []*string{
	// 			to.Ptr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme")},
	// 			Severity: to.Ptr[int32](3),
	// 			WindowSize: to.Ptr("Pt15m"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/deleteMetricAlert.json
func ExampleMetricAlertsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewMetricAlertsClient().Delete(ctx, "gigtest", "chiricutin", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
