# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core import AsyncPipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._utils.serialization import Deserializer, Serializer
from ...operations._sql_vulnerability_assessment_baseline_rules_operations import (
    build_add_request,
    build_create_or_update_request,
    build_delete_request,
    build_get_request,
    build_list_request,
)
from .._configuration import SecurityCenterConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class SqlVulnerabilityAssessmentBaselineRulesOperations:  # pylint: disable=name-too-long
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.security.aio.SecurityCenter`'s
        :attr:`sql_vulnerability_assessment_baseline_rules` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: SecurityCenterConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def create_or_update(
        self,
        rule_id: str,
        workspace_id: str,
        resource_id: str,
        body: Optional[_models.RuleResultsInput] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RuleResults:
        """Creates a Baseline for a rule in a database. Will overwrite any previously existing results.

        Creates a Baseline for a rule in a database. Will overwrite any previously existing results.

        :param rule_id: The rule Id. Required.
        :type rule_id: str
        :param workspace_id: The workspace Id. Required.
        :type workspace_id: str
        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param body: The baseline results for this rule. Default value is None.
        :type body: ~azure.mgmt.security.models.RuleResultsInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RuleResults or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.RuleResults
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self,
        rule_id: str,
        workspace_id: str,
        resource_id: str,
        body: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RuleResults:
        """Creates a Baseline for a rule in a database. Will overwrite any previously existing results.

        Creates a Baseline for a rule in a database. Will overwrite any previously existing results.

        :param rule_id: The rule Id. Required.
        :type rule_id: str
        :param workspace_id: The workspace Id. Required.
        :type workspace_id: str
        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param body: The baseline results for this rule. Default value is None.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RuleResults or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.RuleResults
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update(
        self,
        rule_id: str,
        workspace_id: str,
        resource_id: str,
        body: Optional[Union[_models.RuleResultsInput, IO[bytes]]] = None,
        **kwargs: Any
    ) -> _models.RuleResults:
        """Creates a Baseline for a rule in a database. Will overwrite any previously existing results.

        Creates a Baseline for a rule in a database. Will overwrite any previously existing results.

        :param rule_id: The rule Id. Required.
        :type rule_id: str
        :param workspace_id: The workspace Id. Required.
        :type workspace_id: str
        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param body: The baseline results for this rule. Is either a RuleResultsInput type or a
         IO[bytes] type. Default value is None.
        :type body: ~azure.mgmt.security.models.RuleResultsInput or IO[bytes]
        :return: RuleResults or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.RuleResults
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-02-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RuleResults] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "RuleResultsInput")
            else:
                _json = None

        _request = build_create_or_update_request(
            rule_id=rule_id,
            resource_id=resource_id,
            workspace_id=workspace_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RuleResults", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get(self, rule_id: str, workspace_id: str, resource_id: str, **kwargs: Any) -> _models.RuleResults:
        """Gets the results for a given rule in the Baseline.

        Gets the results for a given rule in the Baseline.

        :param rule_id: The rule Id. Required.
        :type rule_id: str
        :param workspace_id: The workspace Id. Required.
        :type workspace_id: str
        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :return: RuleResults or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.RuleResults
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-02-01-preview"))
        cls: ClsType[_models.RuleResults] = kwargs.pop("cls", None)

        _request = build_get_request(
            rule_id=rule_id,
            resource_id=resource_id,
            workspace_id=workspace_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RuleResults", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete(self, rule_id: str, workspace_id: str, resource_id: str, **kwargs: Any) -> None:
        """Deletes a rule from the Baseline of a given database.

        Deletes a rule from the Baseline of a given database.

        :param rule_id: The rule Id. Required.
        :type rule_id: str
        :param workspace_id: The workspace Id. Required.
        :type workspace_id: str
        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-02-01-preview"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_request(
            rule_id=rule_id,
            resource_id=resource_id,
            workspace_id=workspace_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def list(self, workspace_id: str, resource_id: str, **kwargs: Any) -> _models.RulesResults:
        """Gets the results for all rules in the Baseline.

        Gets the results for all rules in the Baseline.

        :param workspace_id: The workspace Id. Required.
        :type workspace_id: str
        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :return: RulesResults or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.RulesResults
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-02-01-preview"))
        cls: ClsType[_models.RulesResults] = kwargs.pop("cls", None)

        _request = build_list_request(
            resource_id=resource_id,
            workspace_id=workspace_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RulesResults", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def add(
        self,
        workspace_id: str,
        resource_id: str,
        body: Optional[_models.RulesResultsInput] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RulesResults:
        """Add a list of baseline rules. Will overwrite any previously existing results (for all rules).

        Add a list of baseline rules. Will overwrite any previously existing results (for all rules).

        :param workspace_id: The workspace Id. Required.
        :type workspace_id: str
        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param body: The baseline rules. Default value is None.
        :type body: ~azure.mgmt.security.models.RulesResultsInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RulesResults or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.RulesResults
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add(
        self,
        workspace_id: str,
        resource_id: str,
        body: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RulesResults:
        """Add a list of baseline rules. Will overwrite any previously existing results (for all rules).

        Add a list of baseline rules. Will overwrite any previously existing results (for all rules).

        :param workspace_id: The workspace Id. Required.
        :type workspace_id: str
        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param body: The baseline rules. Default value is None.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RulesResults or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.RulesResults
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add(
        self,
        workspace_id: str,
        resource_id: str,
        body: Optional[Union[_models.RulesResultsInput, IO[bytes]]] = None,
        **kwargs: Any
    ) -> _models.RulesResults:
        """Add a list of baseline rules. Will overwrite any previously existing results (for all rules).

        Add a list of baseline rules. Will overwrite any previously existing results (for all rules).

        :param workspace_id: The workspace Id. Required.
        :type workspace_id: str
        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param body: The baseline rules. Is either a RulesResultsInput type or a IO[bytes] type.
         Default value is None.
        :type body: ~azure.mgmt.security.models.RulesResultsInput or IO[bytes]
        :return: RulesResults or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.RulesResults
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-02-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RulesResults] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "RulesResultsInput")
            else:
                _json = None

        _request = build_add_request(
            resource_id=resource_id,
            workspace_id=workspace_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RulesResults", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
