% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{gsub_file}
\alias{gsub_file}
\alias{gsub_files}
\alias{gsub_dir}
\alias{gsub_ext}
\title{Search and replace strings in files}
\usage{
gsub_file(file, ..., rw_error = TRUE)

gsub_files(files, ...)

gsub_dir(..., dir = ".", recursive = TRUE, ext = NULL, mimetype = ".*")

gsub_ext(ext, ..., dir = ".", recursive = TRUE)
}
\arguments{
\item{file}{Path of a single file.}

\item{...}{For \code{gsub_file()}, arguments passed to \code{gsub()}. For
other functions, arguments passed to \code{gsub_file()}. Note that the
argument \code{x} of \code{gsub()} is the content of the file.}

\item{rw_error}{Whether to signal an error if the file cannot be read or
written. If \code{FALSE}, the file will be ignored (with a warning).}

\item{files}{A vector of file paths.}

\item{dir}{Path to a directory (all files under this directory will be
replaced).}

\item{recursive}{Whether to find files recursively under a directory.}

\item{ext}{A vector of filename extensions (without the leading periods).}

\item{mimetype}{A regular expression to filter files based on their MIME
types, e.g., \code{'^text/'} for plain text files.}
}
\description{
These functions provide the "file" version of \code{\link[=gsub]{gsub()}}, i.e.,
they perform searching and replacement in files via \code{gsub()}.
}
\note{
These functions perform in-place replacement, i.e., the files will be
overwritten. Make sure you backup your files in advance, or use version
control!
}
\examples{
library(xfun)
f = tempfile()
writeLines(c("hello", "world"), f)
gsub_file(f, "world", "woRld", fixed = TRUE)
readLines(f)
}
