% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{md5}
\alias{md5}
\title{Calculate the MD5 checksums of R objects}
\usage{
md5(...)
}
\arguments{
\item{...}{Any number of R objects.}
}
\value{
A character vector of the checksums of objects passed to \code{md5()}. If
the arguments are named, the results will also be named.
}
\description{
\link[=serialize]{Serialize} an object and calculate the checksum via
\code{\link[tools:md5sum]{tools::md5sum()}}. If \code{tools::md5sum()} does not have the argument \code{bytes},
the object will be first serialized to a temporary file, which will be
deleted after the checksum is calculated, otherwise the raw bytes of the
object will be passed to the \code{bytes} argument directly (which will be
faster than writing to a temporary file).
}
\examples{
x1 = 1
x2 = 1:10
x3 = seq(1, 10)
x4 = iris
x5 = paste
(m = xfun::md5(x1, x2, x3, x4, x5))
stopifnot(m[2] == m[3])  # x2 and x3 should be identical

xfun::md5(x1 = x1, x2 = x2)  # named arguments
}
