# Buildah version 1.2 Release Announcement

![buildah logo](https://cdn.rawgit.com/containers/buildah/main/logos/buildah-logo_large.png)

We're pleased to announce the release of Buildah version 1.2 which is now available from GitHub for any Linux distro.  We are shipping this release on Fedora, RHEL 7, CentOS and Ubuntu in the near future.

The Buildah project has continued to grow over the past several weeks, welcoming several new contributors to the mix.  The highlights of this release are the added ability to control image layers when building an image, CVE’s Fixes, the initial support for user namespace handling and several other enhancements and bug fixes.

## The major highlights for this release are:

### Allow the user to control the layers of the image when the image is built with the ‘buildah bud’ command.

A container is comprised of a final readable/writeable layer and when the layers are cached, a number of intermediate read only layers.  The read only layers are created with each step in the Dockerfile and the final readable/writeable layer contains the intermediate layers.  Prior to these changes Buildah did not cache these intermediate read only layers.

This release has a new environment variable ‘BUILDAH_LAYERS’ and a new ‘buildah bud’ --layers parameter.  When either is set to true, the image layers are cached during the ‘buildah bud’ processing and not discarded.  The disadvantage to retaining layers is the space that they use.  The advantage to retaining them is if you make a change to your Dockerfile, only the layers for that change and the ones following it will need to be regenerated.

The --nocache parameter has also been added to the ‘buildah bud’ command.  When this parameter is set to true the ‘buildah bud’ command ignores any existing layers and creates all of the image layers anew.

### Added initial user namespace support.

To isolate the container’s processes from running as root on the host machine, user namespaces are used by container technologies.  This allows the administrator to configure the containers processes that must run as root to remap the user to a less privileged user on the container’s host machine.  This remapping is handled in part by settings in the /etc/subuid and /etc/subgid files on the host machine.

The changes for this release does not yet provide full support for user namespaces, but does set up the options to control the mapping with the --userns-uid-map and --userns-gid-map options.   Changes have also been made to prevent the container from modifying the /etc/host or /etc/resolv.conf files on the host.

Also with this release if a user with a uid that’s not equal to zero creates a container, a namespace is now created based on the users uid and gid and the container will be reexec’d using that namespace.   In addition, the storage driver, storage root directory and storage state directory will all be created under alternate locations.  Please reference the buildah (1) man page for more details.  Further information will be published in upcoming blogs and additional changes are in progress to provide full support of user namespaces in future versions of Buildah.

### CVE security issues with /proc/acpi and /proc/keys have been addressed.

The /proc/acpi and /proc/keys were added to the list of blocked kernel files.  This prevents the container from manipulating these files on the container’s host.

## Release Changes
 * Added the ability to remove or retain image layers for ‘buildah bud’:
   * Add --layers and --no-cache options to 'buildah bud'.
   * Add --rm and --force-rm options to 'buildah bud'.
   * Fixed the buildah bud --layers option.
   * Added environment variable BUILDAH_LAYERS to control image layers creation.
 * Added environment variable BUILDAH_RUNTIME to setup alternate runtimes.
 * build-using-dockerfile: let -t include transports again.
 * Block the use of /proc/acpi and /proc/keys from inside containers. These address potential CVE Security issues.
 * Add --cidfile option to 'buildah from`.
 * Add a --loglevel option to build-with-dockerfile.
 * Begin supporting specification of user namespace for container separation:
   * Allow --userns-uid-map/--userns-gid-map to be global options.
   * If unprivileged, reexec in a user namespace.
   * Force ownership of /etc/hosts and /etc/resolv.conf to 0:0.
 * Recognize committing to second storage locations with 'buildah commit'.
 * Add the --all option to 'buildah unmount' to unmount all mounted containers.
 * When doing multiple mounts, output all pertinent errors, not just the last error.
 * Implement basic recognition of the "--isolation" option for 'buildah from' and 'buildah run'.
 * Fix ARGS parsing for run commands.
 * When building a container the HTTP User-Agent is set to the Buildah version.
 * Makefile: add the uninstall command.
 * Support multiple inputs to 'buildah mount'.
 * Use the right formatting when adding entries to /etc/hosts.
 * A number of minor performance improvements for 'buildah run' and 'buildah bud'.
 * Change RunOptions.Stdin/Stdout/Stderr to just be Reader/Writers.
 * Use conversion code from containers/image instead of converting configs manually.
 * Do not ignore any parsing errors during initialization.
 * Explicitly handle "from scratch" images in Builder.initConfig.
 * Fix parsing of OCI images.
 * Don't ignore v2s1 history if docker_version is not set.
 * Add --all,-a flags to 'buildah images'.
 * Remove tty check from buildah images --format.
 * Fix usage information for 'buildah images'.
 * Documentation changes:
   * Add registries.conf link to a few man pages.
   * Add information about the configuration files to the install documentation.
   * Follow man-pages(7) suggestions for SYNOPSIS in all man pages.
   * Minor update to buildah config documentation for entrypoint.
   * ONBUILD tutorial created.
   * Touch up images man page.
 * Plus a number of smaller fixes.

## Try it Out.

If you haven’t yet, install Buildah from the Fedora repo or GitHub and give it a spin.  We’re betting you'll find it’s an easy and quick way to build containers in your environment without a daemon being involved!

For those of you who contributed to this release, thank you very much for your contributions!  If you haven't joined our community yet, don't wait any longer!  Come join us in GitHub, where Open Source communities live.

## Buildah == Simplicity

