/* SPDX-License-Identifier: GPL-2.0-or-later */
/* This file was generated by: ./scripts/crypto/gen-hash-testvecs.py md5 */

static const struct {
	size_t data_len;
	u8 digest[MD5_DIGEST_SIZE];
} hash_testvecs[] = {
	{
		.data_len = 0,
		.digest = {
			0xd4, 0x1d, 0x8c, 0xd9, 0x8f, 0x00, 0xb2, 0x04,
			0xe9, 0x80, 0x09, 0x98, 0xec, 0xf8, 0x42, 0x7e,
		},
	},
	{
		.data_len = 1,
		.digest = {
			0x16, 0x7b, 0x86, 0xf2, 0x1d, 0xf3, 0x76, 0xc9,
			0x6f, 0x10, 0xa0, 0x61, 0x5b, 0x14, 0x20, 0x0b,
		},
	},
	{
		.data_len = 2,
		.digest = {
			0x2d, 0x30, 0x96, 0xc7, 0x43, 0x40, 0xed, 0xb2,
			0xfb, 0x84, 0x63, 0x9a, 0xec, 0xc7, 0x3c, 0x3c,
		},
	},
	{
		.data_len = 3,
		.digest = {
			0xe5, 0x0f, 0xce, 0xe0, 0xc8, 0xff, 0x4e, 0x08,
			0x5e, 0x19, 0xe5, 0xf2, 0x08, 0x11, 0x19, 0x16,
		},
	},
	{
		.data_len = 16,
		.digest = {
			0xe8, 0xca, 0x29, 0x05, 0x2f, 0xd1, 0xf3, 0x99,
			0x40, 0x71, 0xf5, 0xc2, 0xf7, 0xf8, 0x17, 0x3e,
		},
	},
	{
		.data_len = 32,
		.digest = {
			0xe3, 0x20, 0xc1, 0xd8, 0x21, 0x14, 0x44, 0x59,
			0x1a, 0xf5, 0x91, 0xaf, 0x69, 0xbe, 0x93, 0x9d,
		},
	},
	{
		.data_len = 48,
		.digest = {
			0xfb, 0x06, 0xb0, 0xf0, 0x00, 0x10, 0x4b, 0x68,
			0x3d, 0x75, 0xf9, 0x70, 0xde, 0xbb, 0x32, 0x16,
		},
	},
	{
		.data_len = 49,
		.digest = {
			0x52, 0x86, 0x48, 0x8b, 0xae, 0x91, 0x7c, 0x4e,
			0xc2, 0x2a, 0x69, 0x07, 0x35, 0xcc, 0xb2, 0x88,
		},
	},
	{
		.data_len = 63,
		.digest = {
			0xfa, 0xd3, 0xf6, 0xe6, 0x7b, 0x1a, 0xc6, 0x05,
			0x73, 0x35, 0x02, 0xab, 0xc7, 0xb3, 0x47, 0xcb,
		},
	},
	{
		.data_len = 64,
		.digest = {
			0xc5, 0x59, 0x29, 0xe9, 0x0a, 0x4a, 0x86, 0x43,
			0x7c, 0xaf, 0xdf, 0x83, 0xd3, 0xb8, 0x33, 0x5f,
		},
	},
	{
		.data_len = 65,
		.digest = {
			0x80, 0x05, 0x75, 0x39, 0xec, 0x44, 0x8a, 0x81,
			0xe7, 0x6e, 0x8d, 0xd1, 0xc6, 0xeb, 0xc2, 0xf0,
		},
	},
	{
		.data_len = 127,
		.digest = {
			0x3f, 0x02, 0xe8, 0xc6, 0xb8, 0x6a, 0x39, 0xc3,
			0xa4, 0x1c, 0xd9, 0x8f, 0x4a, 0x71, 0x40, 0x30,
		},
	},
	{
		.data_len = 128,
		.digest = {
			0x89, 0x4f, 0x79, 0x3e, 0xff, 0x0c, 0x22, 0x60,
			0xa2, 0xdc, 0x10, 0x5f, 0x23, 0x0a, 0xe7, 0xc6,
		},
	},
	{
		.data_len = 129,
		.digest = {
			0x06, 0x56, 0x61, 0xb8, 0x8a, 0x82, 0x77, 0x1b,
			0x2c, 0x35, 0xb8, 0x9f, 0xd6, 0xf7, 0xbd, 0x5a,
		},
	},
	{
		.data_len = 256,
		.digest = {
			0x5d, 0xdf, 0x7d, 0xc8, 0x43, 0x96, 0x3b, 0xdb,
			0xc7, 0x0e, 0x44, 0x42, 0x23, 0xf7, 0xed, 0xdf,
		},
	},
	{
		.data_len = 511,
		.digest = {
			0xf6, 0x5f, 0x26, 0x51, 0x8a, 0x5a, 0x46, 0x8f,
			0x48, 0x72, 0x90, 0x74, 0x9d, 0x87, 0xbd, 0xdf,
		},
	},
	{
		.data_len = 513,
		.digest = {
			0xd8, 0x2c, 0xc9, 0x76, 0xfa, 0x67, 0x2e, 0xa6,
			0xc8, 0x12, 0x4a, 0x64, 0xaa, 0x0b, 0x3d, 0xbd,
		},
	},
	{
		.data_len = 1000,
		.digest = {
			0xe2, 0x7e, 0xb4, 0x5f, 0xe1, 0x74, 0x51, 0xfc,
			0xe0, 0xc8, 0xd5, 0xe6, 0x8b, 0x40, 0xd2, 0x0e,
		},
	},
	{
		.data_len = 3333,
		.digest = {
			0xcd, 0x7d, 0x56, 0xa9, 0x4c, 0x47, 0xea, 0xc2,
			0x34, 0x0b, 0x84, 0x05, 0xf9, 0xad, 0xbb, 0x46,
		},
	},
	{
		.data_len = 4096,
		.digest = {
			0x63, 0x6e, 0x58, 0xb3, 0x94, 0x6b, 0x83, 0x5f,
			0x1f, 0x0e, 0xd3, 0x66, 0x78, 0x71, 0x98, 0x42,
		},
	},
	{
		.data_len = 4128,
		.digest = {
			0x9d, 0x68, 0xfc, 0x26, 0x8b, 0x4c, 0xa8, 0xe7,
			0x30, 0x0b, 0x19, 0x52, 0x6e, 0xa5, 0x65, 0x1c,
		},
	},
	{
		.data_len = 4160,
		.digest = {
			0x1c, 0xaa, 0x7d, 0xee, 0x91, 0x01, 0xe2, 0x5a,
			0xec, 0xe9, 0xde, 0x57, 0x0a, 0xb6, 0x4c, 0x2f,
		},
	},
	{
		.data_len = 4224,
		.digest = {
			0x1b, 0x31, 0xe3, 0x14, 0x07, 0x16, 0x17, 0xc6,
			0x98, 0x79, 0x88, 0x23, 0xb6, 0x3b, 0x25, 0xc4,
		},
	},
	{
		.data_len = 16384,
		.digest = {
			0xc6, 0x3d, 0x56, 0x90, 0xf0, 0xf6, 0xe6, 0x50,
			0xf4, 0x76, 0x78, 0x67, 0xa3, 0xdd, 0x62, 0x7b,
		},
	},
};

static const u8 hash_testvec_consolidated[MD5_DIGEST_SIZE] = {
	0x70, 0x86, 0x9e, 0x6c, 0xa4, 0xc6, 0x71, 0x43,
	0x26, 0x02, 0x1b, 0x3f, 0xfd, 0x56, 0x9f, 0xa6,
};

static const u8 hmac_testvec_consolidated[MD5_DIGEST_SIZE] = {
	0x10, 0x02, 0x74, 0xf6, 0x4d, 0xb3, 0x3c, 0xc7,
	0xa1, 0xf7, 0xe6, 0xd4, 0x32, 0x64, 0xfa, 0x6d,
};
