# Generated by Django 4.2.14 on 2024-07-24 15:53

from django.db import migrations

from mini_buildd import dist

LINTIAN_EXTRA_OPTIONS_PREVIOUS_DEFAULT = "--info"


def migrate_lintian_options(apps, _schema_editor):
    Distribution = apps.get_model("mini_buildd", "Distribution")
    for d in Distribution.objects.all():
        codename = dist.Codename(d.base_source.codename)
        setup_options = codename.setup_distribution_options()
        if d.lintian_extra_options == LINTIAN_EXTRA_OPTIONS_PREVIOUS_DEFAULT:
            d.lintian_extra_options = setup_options.get("lintian_extra_options", dist.SETUP["defaults"]["distribution"]["lintian_extra_options"])
        d.lintian_warnfail_options = setup_options.get("lintian_warnfail_options", dist.SETUP["defaults"]["distribution"]["lintian_warnfail_options"])
        d.save()


class Migration(migrations.Migration):

    dependencies = [
        ('mini_buildd', '0032_distribution_lintian_warnfail_options_and_more'),
    ]

    operations = [
        migrations.RunPython(migrate_lintian_options),
    ]
